// 生成PNG图标的Node.js脚本
// 需要安装canvas: npm install canvas

const fs = require('fs');
const path = require('path');

// 检查是否安装了canvas
let Canvas;
try {
  Canvas = require('canvas');
} catch (error) {
  console.log('请先安装canvas: npm install canvas');
  process.exit(1);
}

function createIcon(size) {
  const canvas = Canvas.createCanvas(size, size);
  const ctx = canvas.getContext('2d');
  
  // 设置背景
  ctx.fillStyle = '#4F46E5';
  ctx.fillRect(0, 0, size, size);
  
  // 绘制购物袋
  const scale = size / 16;
  const bagWidth = 8 * scale;
  const bagHeight = 10 * scale;
  const bagX = (size - bagWidth) / 2;
  const bagY = (size - bagHeight) / 2;
  
  // 购物袋主体
  ctx.fillStyle = 'white';
  ctx.fillRect(bagX, bagY + 2 * scale, bagWidth, bagHeight - 2 * scale);
  
  // 购物袋顶部
  ctx.fillRect(bagX - 1 * scale, bagY, bagWidth + 2 * scale, 2 * scale);
  
  // 购物袋手柄
  ctx.strokeStyle = 'white';
  ctx.lineWidth = 1 * scale;
  ctx.beginPath();
  ctx.arc(bagX + bagWidth/2, bagY + 1 * scale, 1.5 * scale, 0, Math.PI);
  ctx.stroke();
  
  // 购物袋装饰线条
  ctx.strokeStyle = '#4F46E5';
  ctx.lineWidth = 0.5 * scale;
  ctx.beginPath();
  ctx.moveTo(bagX + 1 * scale, bagY + 4 * scale);
  ctx.lineTo(bagX + bagWidth - 1 * scale, bagY + 4 * scale);
  ctx.moveTo(bagX + 1 * scale, bagY + 6 * scale);
  ctx.lineTo(bagX + bagWidth - 1 * scale, bagY + 6 * scale);
  ctx.stroke();
  
  // 添加小圆点装饰
  ctx.fillStyle = '#4F46E5';
  ctx.beginPath();
  ctx.arc(bagX + 2 * scale, bagY + 5 * scale, 0.5 * scale, 0, 2 * Math.PI);
  ctx.fill();
  ctx.beginPath();
  ctx.arc(bagX + bagWidth - 2 * scale, bagY + 5 * scale, 0.5 * scale, 0, 2 * Math.PI);
  ctx.fill();
  
  return canvas;
}

function generateIcons() {
  const sizes = [16, 48, 128];
  
  sizes.forEach(size => {
    const canvas = createIcon(size);
    const buffer = canvas.toBuffer('image/png');
    const filename = `icon${size}.png`;
    const filepath = path.join(__dirname, filename);
    
    fs.writeFileSync(filepath, buffer);
    console.log(`✅ 生成 ${filename}`);
  });
  
  console.log('\n🎉 所有图标生成完成！');
  console.log('📁 图标文件位置:');
  console.log('   - icon16.png (16x16像素)');
  console.log('   - icon48.png (48x48像素)');
  console.log('   - icon128.png (128x128像素)');
}

// 运行生成器
generateIcons();
