# 电商插件图标

本目录包含Chrome电商插件所需的图标文件。

## 图标文件

### SVG格式（矢量图标）
- `icon16.svg` - 16x16像素矢量图标
- `icon48.svg` - 48x48像素矢量图标  
- `icon128.svg` - 128x128像素矢量图标

### 生成工具
- `generate-icons.html` - 浏览器图标生成器
- `generate-png.js` - Node.js PNG图标生成器

## 图标设计说明

### 设计理念
- **主题色**: #4F46E5 (靛蓝色)
- **图标元素**: 购物袋 + 装饰线条
- **风格**: 现代简约，适合电商主题

### 图标元素
1. **购物袋主体** - 白色背景的购物袋形状
2. **购物袋手柄** - 弧形手柄设计
3. **装饰线条** - 水平线条增加层次感
4. **圆点装饰** - 小圆点增加细节

## 使用方法

### 方法1: 使用SVG图标（推荐）
直接使用SVG文件，Chrome会自动处理缩放：

```json
{
  "icons": {
    "16": "icons/icon16.svg",
    "48": "icons/icon48.svg", 
    "128": "icons/icon128.svg"
  }
}
```

### 方法2: 生成PNG图标
1. 打开 `generate-icons.html` 在浏览器中
2. 点击"下载"按钮获取PNG文件
3. 或者运行 `node generate-png.js`（需要安装canvas）

### 方法3: 在线转换
1. 使用在线SVG转PNG工具
2. 上传SVG文件
3. 设置对应尺寸
4. 下载PNG文件

## 图标规格

| 尺寸 | 用途 | 文件名 |
|------|------|--------|
| 16x16 | 扩展程序管理页面 | icon16.png |
| 48x48 | 扩展程序管理页面 | icon48.png |
| 128x128 | Chrome Web Store | icon128.png |

## 自定义图标

如需修改图标：
1. 编辑SVG文件
2. 调整颜色、形状或元素
3. 重新生成PNG文件
4. 更新manifest.json中的引用

## 注意事项

- 确保图标在不同背景下都清晰可见
- 保持图标的简洁性，避免过多细节
- 测试图标在小尺寸下的可读性
- 遵循Chrome扩展图标设计规范