var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
import { _ as _export_sfc, w as withModifiers, v as vModelText, c as createApp } from "./_plugin-vue_export-helper-7fiB1ynU.js";
import { d as defineComponent, r as ref, c as computed, o as onMounted, a as createElementBlock, b as openBlock, e as createCommentVNode, n as normalizeClass, f as createBaseVNode, t as toDisplayString, g as getLatestVersionAPI, w as watch, h as createBlock, i as createTextVNode, j as withDirectives, l as loginAPI, k as registerAPI, m as onUnmounted, F as Fragment, p as renderList, q as createStaticVNode, u as updateEffectAPI, s as logError, v as normalizeStyle, x as getPlanListAPI, y as resetSyncAPI, z as unref, A as createVNode, _ as __vitePreload, B as validateAccountAPI } from "./client-F2KO4iwg.js";
import { getCredentials, saveToken, saveCredentials, removeToken, autoLogin } from "./auth-qwMo_0s-.js";
import { T as TaskStatus, S as StageStatus, g as getTaskStatusInfo, a as getStageClass, u as useGlobalState, G as GlobalStateManager } from "./global-state-manager-nkA3ulMh.js";
const _hoisted_1$b = ["title"];
const _hoisted_2$a = {
  key: 0,
  class: "icon update-icon",
  viewBox: "0 0 24 24",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_3$a = {
  key: 1,
  class: "icon check-icon",
  viewBox: "0 0 24 24",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_4$8 = { class: "version-text" };
const _hoisted_5$8 = {
  key: 1,
  class: "version-loading"
};
const _sfc_main$b = /* @__PURE__ */ defineComponent({
  __name: "VersionStatus",
  props: {
    userToken: {}
  },
  setup(__props, { expose: __expose }) {
    const props = __props;
    const versionInfo = ref(null);
    const isLoading = ref(false);
    const error = ref("");
    const versionIconClass = computed(() => {
      var _a, _b, _c;
      return {
        "need-update": (_a = versionInfo.value) == null ? void 0 : _a.needUpdate,
        "up-to-date": !((_b = versionInfo.value) == null ? void 0 : _b.needUpdate),
        "clickable": (_c = versionInfo.value) == null ? void 0 : _c.needUpdate
        // 需要更新时就可点击
      };
    });
    const tooltipText = computed(() => {
      if (!versionInfo.value) return "版本检查中...";
      if (versionInfo.value.needUpdate) {
        if (versionInfo.value.downloadUrl) {
          return `当前版本: v${versionInfo.value.currentVersion}
最新版本: v${versionInfo.value.latestVersion}
点击下载最新版本`;
        } else {
          return `当前版本: v${versionInfo.value.currentVersion}
最新版本: v${versionInfo.value.latestVersion}
发现新版本，请联系管理员获取`;
        }
      } else {
        return `当前版本: v${versionInfo.value.currentVersion}
已是最新版本`;
      }
    });
    const checkVersion = () => __async(this, null, function* () {
      if (!props.userToken) {
        console.warn("⚠️ 没有用户token，跳过版本检查");
        return;
      }
      try {
        isLoading.value = true;
        error.value = "";
        console.log("🔍 开始检查版本更新...");
        const result = yield getLatestVersionAPI(props.userToken);
        versionInfo.value = result;
        if (result.needUpdate) {
          console.log("📢 发现新版本:", {
            current: result.currentVersion,
            latest: result.latestVersion,
            downloadUrl: result.downloadUrl
          });
        } else {
          console.log("✅ 当前已是最新版本:", result.currentVersion);
        }
      } catch (err) {
        console.error("❌ 版本检查失败:", err);
        error.value = err.message || "版本检查失败";
      } finally {
        isLoading.value = false;
      }
    });
    const handleClick = () => {
      var _a, _b;
      if (!((_a = versionInfo.value) == null ? void 0 : _a.needUpdate)) {
        console.log("ℹ️ 当前已是最新版本，无需下载");
        return;
      }
      if ((_b = versionInfo.value) == null ? void 0 : _b.downloadUrl) {
        console.log("📥 打开新版本下载:", versionInfo.value.downloadUrl);
        chrome.tabs.create({ url: versionInfo.value.downloadUrl });
      } else {
        console.warn("⚠️ 没有配置下载地址");
        alert("下载地址未配置，请联系管理员获取最新版本");
      }
    };
    onMounted(() => {
      if (props.userToken) {
        checkVersion();
      }
    });
    __expose({
      checkVersion
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: "version-status",
        title: tooltipText.value
      }, [
        versionInfo.value ? (openBlock(), createElementBlock("div", {
          key: 0,
          class: normalizeClass(["version-icon", versionIconClass.value]),
          onClick: handleClick
        }, [
          versionInfo.value.needUpdate ? (openBlock(), createElementBlock("svg", _hoisted_2$a, [..._cache[0] || (_cache[0] = [
            createBaseVNode("circle", {
              cx: "12",
              cy: "12",
              r: "10",
              fill: "#F59E0B"
            }, null, -1),
            createBaseVNode("path", {
              d: "M12 8v4M12 16h.01",
              stroke: "white",
              "stroke-width": "2",
              "stroke-linecap": "round",
              "stroke-linejoin": "round"
            }, null, -1)
          ])])) : (openBlock(), createElementBlock("svg", _hoisted_3$a, [..._cache[1] || (_cache[1] = [
            createBaseVNode("circle", {
              cx: "12",
              cy: "12",
              r: "10",
              fill: "#10B981"
            }, null, -1),
            createBaseVNode("path", {
              d: "M9 12l2 2 4-4",
              stroke: "white",
              "stroke-width": "2",
              "stroke-linecap": "round",
              "stroke-linejoin": "round"
            }, null, -1)
          ])])),
          createBaseVNode("span", _hoisted_4$8, "v" + toDisplayString(versionInfo.value.currentVersion), 1)
        ], 2)) : isLoading.value ? (openBlock(), createElementBlock("div", _hoisted_5$8, [..._cache[2] || (_cache[2] = [
          createBaseVNode("div", { class: "loading-spinner" }, null, -1)
        ])])) : createCommentVNode("", true)
      ], 8, _hoisted_1$b);
    };
  }
});
const VersionStatus = /* @__PURE__ */ _export_sfc(_sfc_main$b, [["__scopeId", "data-v-aacca2a9"]]);
const _hoisted_1$a = { class: "page-header" };
const _hoisted_2$9 = { class: "header-content" };
const _hoisted_3$9 = { class: "header-right" };
const _hoisted_4$7 = {
  key: 2,
  class: "user-info"
};
const _hoisted_5$7 = { class: "user-avatar" };
const _hoisted_6$7 = { class: "avatar-text" };
const _hoisted_7$7 = { class: "user-details" };
const _hoisted_8$6 = { class: "user-name" };
const _sfc_main$a = /* @__PURE__ */ defineComponent({
  __name: "PageHeader",
  props: {
    userInfo: {}
  },
  emits: ["logout"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const versionStatusRef = ref();
    watch(() => props.userInfo, (newUserInfo) => {
      console.log("PageHeader userInfo 变化:", newUserInfo);
      if (newUserInfo && versionStatusRef.value) {
        versionStatusRef.value.checkVersion();
      }
    }, { deep: true });
    const emit = __emit;
    const handleLogout = () => {
      emit("logout");
    };
    const openDocumentation = () => {
      chrome.tabs.create({
        url: "https://123.57.142.14/coo-docs/"
      });
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$a, [
        createBaseVNode("div", _hoisted_2$9, [
          _cache[2] || (_cache[2] = createBaseVNode("div", { class: "header-left" }, [
            createBaseVNode("div", { class: "app-logo" }, [
              createBaseVNode("div", { class: "logo-icon" }, "🚀"),
              createBaseVNode("h1", { class: "app-title" }, "电商助手")
            ])
          ], -1)),
          createBaseVNode("div", _hoisted_3$9, [
            _ctx.userInfo ? (openBlock(), createElementBlock("a", {
              key: 0,
              href: "https://123.57.142.14/coo-docs/",
              target: "_blank",
              class: "doc-link",
              title: "在线文档",
              onClick: withModifiers(openDocumentation, ["prevent"])
            }, [..._cache[0] || (_cache[0] = [
              createBaseVNode("span", { class: "doc-icon" }, "📋", -1)
            ])])) : createCommentVNode("", true),
            _ctx.userInfo ? (openBlock(), createBlock(VersionStatus, {
              key: 1,
              "user-token": _ctx.userInfo.token,
              ref_key: "versionStatusRef",
              ref: versionStatusRef
            }, null, 8, ["user-token"])) : createCommentVNode("", true),
            _ctx.userInfo ? (openBlock(), createElementBlock("div", _hoisted_4$7, [
              createBaseVNode("div", _hoisted_5$7, [
                createBaseVNode("span", _hoisted_6$7, toDisplayString(_ctx.userInfo.username.charAt(0).toUpperCase()), 1)
              ]),
              createBaseVNode("div", _hoisted_7$7, [
                createBaseVNode("span", _hoisted_8$6, toDisplayString(_ctx.userInfo.username), 1),
                createBaseVNode("button", {
                  onClick: handleLogout,
                  class: "logout-btn"
                }, [..._cache[1] || (_cache[1] = [
                  createBaseVNode("span", { class: "logout-icon" }, "↗", -1)
                ])])
              ])
            ])) : createCommentVNode("", true)
          ])
        ])
      ]);
    };
  }
});
const PageHeader = /* @__PURE__ */ _export_sfc(_sfc_main$a, [["__scopeId", "data-v-cf3d8a00"]]);
const _hoisted_1$9 = { class: "login-container" };
const _hoisted_2$8 = { class: "login-content" };
const _hoisted_3$8 = { class: "form-group" };
const _hoisted_4$6 = { class: "input-wrapper" };
const _hoisted_5$6 = ["disabled"];
const _hoisted_6$6 = { class: "form-group" };
const _hoisted_7$6 = { class: "input-wrapper" };
const _hoisted_8$5 = ["disabled"];
const _hoisted_9$5 = ["disabled"];
const _hoisted_10$5 = {
  key: 0,
  class: "loading-spinner"
};
const _hoisted_11$5 = { key: 1 };
const _hoisted_12$3 = { key: 2 };
const _hoisted_13$3 = {
  key: 0,
  class: "error-message"
};
const _hoisted_14$3 = { class: "error-text" };
const _hoisted_15$2 = { class: "login-footer" };
const _sfc_main$9 = /* @__PURE__ */ defineComponent({
  __name: "Login",
  emits: ["login-success", "switch-to-register"],
  setup(__props, { emit: __emit }) {
    const username = ref("");
    const password = ref("");
    const loading = ref(false);
    const errorMessage = ref("");
    const handleLogin = () => __async(this, null, function* () {
      if (!username.value || !password.value) {
        errorMessage.value = "请输入用户名和密码";
        return;
      }
      loading.value = true;
      errorMessage.value = "";
      try {
        console.log("调用登录API");
        const loginData = {
          userCode: username.value,
          password: password.value
        };
        const response = yield loginAPI(loginData);
        if (response.code === "0" && response.data) {
          const { token, user, accountType } = response.data;
          const apiUsername = user.userName || user.userCode;
          yield saveToken(token, true, apiUsername, accountType);
          yield saveCredentials(username.value, password.value, true);
          emit("login-success", { username: apiUsername, token, accountType });
        } else {
          errorMessage.value = response.msg || "登录失败";
        }
      } catch (error) {
        console.error("登录失败:", error);
        if (error && typeof error === "object" && "code" in error && "message" in error) {
          const apiError = error;
          if (apiError.code === 401) {
            errorMessage.value = apiError.message || "用户名或密码错误";
          } else {
            errorMessage.value = apiError.message || "登录失败，请重试";
          }
        } else {
          errorMessage.value = "网络请求失败，请检查服务器连接";
        }
      } finally {
        loading.value = false;
      }
    });
    const loadCredentials = () => __async(this, null, function* () {
      try {
        const credentials = yield getCredentials();
        if (credentials) {
          username.value = credentials.username;
          password.value = credentials.password;
          console.log("已自动填充保存的账号密码");
        }
      } catch (error) {
        console.error("加载保存的账号密码失败:", error);
      }
    });
    onMounted(() => __async(this, null, function* () {
      yield loadCredentials();
    }));
    const switchToRegister = () => {
      emit("switch-to-register");
    };
    const emit = __emit;
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$9, [
        createBaseVNode("div", _hoisted_2$8, [
          _cache[6] || (_cache[6] = createBaseVNode("div", { class: "login-header" }, [
            createBaseVNode("h2", null, [
              createTextVNode("欢迎使用 "),
              createBaseVNode("span", { class: "brand-name" }, "析哦哦"),
              createTextVNode(" 电商助手")
            ]),
            createBaseVNode("p", null, "我们将为您提供专业的智能营销支持")
          ], -1)),
          createBaseVNode("form", {
            onSubmit: withModifiers(handleLogin, ["prevent"]),
            class: "login-form"
          }, [
            createBaseVNode("div", _hoisted_3$8, [
              createBaseVNode("div", _hoisted_4$6, [
                _cache[2] || (_cache[2] = createBaseVNode("div", { class: "input-icon" }, "👤", -1)),
                withDirectives(createBaseVNode("input", {
                  id: "username",
                  "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => username.value = $event),
                  type: "text",
                  placeholder: "用户名",
                  required: "",
                  disabled: loading.value,
                  class: "form-input"
                }, null, 8, _hoisted_5$6), [
                  [vModelText, username.value]
                ])
              ])
            ]),
            createBaseVNode("div", _hoisted_6$6, [
              createBaseVNode("div", _hoisted_7$6, [
                _cache[3] || (_cache[3] = createBaseVNode("div", { class: "input-icon" }, "🔒", -1)),
                withDirectives(createBaseVNode("input", {
                  id: "password",
                  "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => password.value = $event),
                  type: "password",
                  placeholder: "密码",
                  required: "",
                  disabled: loading.value,
                  class: "form-input"
                }, null, 8, _hoisted_8$5), [
                  [vModelText, password.value]
                ])
              ])
            ]),
            createBaseVNode("button", {
              type: "submit",
              class: "login-btn",
              disabled: loading.value || !username.value || !password.value
            }, [
              loading.value ? (openBlock(), createElementBlock("span", _hoisted_10$5)) : createCommentVNode("", true),
              loading.value ? (openBlock(), createElementBlock("span", _hoisted_11$5, "登录中...")) : (openBlock(), createElementBlock("span", _hoisted_12$3, "登录"))
            ], 8, _hoisted_9$5)
          ], 32),
          errorMessage.value ? (openBlock(), createElementBlock("div", _hoisted_13$3, [
            _cache[4] || (_cache[4] = createBaseVNode("div", { class: "error-icon" }, "⚠️", -1)),
            createBaseVNode("span", _hoisted_14$3, toDisplayString(errorMessage.value), 1)
          ])) : createCommentVNode("", true),
          createBaseVNode("div", _hoisted_15$2, [
            createBaseVNode("p", null, [
              _cache[5] || (_cache[5] = createTextVNode("首次使用？", -1)),
              createBaseVNode("a", {
                href: "#",
                onClick: withModifiers(switchToRegister, ["prevent"])
              }, "去注册")
            ])
          ])
        ])
      ]);
    };
  }
});
const Login = /* @__PURE__ */ _export_sfc(_sfc_main$9, [["__scopeId", "data-v-63ebcf0c"]]);
const _hoisted_1$8 = { class: "register-container" };
const _hoisted_2$7 = { class: "register-form" };
const _hoisted_3$7 = { class: "form-row" };
const _hoisted_4$5 = { class: "form-group half" };
const _hoisted_5$5 = { class: "label-input-row" };
const _hoisted_6$5 = { class: "input-wrapper" };
const _hoisted_7$5 = ["disabled"];
const _hoisted_8$4 = { class: "form-group half" };
const _hoisted_9$4 = { class: "label-input-row right-label" };
const _hoisted_10$4 = { class: "input-wrapper" };
const _hoisted_11$4 = ["disabled"];
const _hoisted_12$2 = { class: "form-row" };
const _hoisted_13$2 = { class: "form-group half" };
const _hoisted_14$2 = { class: "label-input-row" };
const _hoisted_15$1 = { class: "input-wrapper" };
const _hoisted_16$1 = ["disabled"];
const _hoisted_17$1 = { class: "form-group half" };
const _hoisted_18$1 = { class: "label-input-row right-label" };
const _hoisted_19$1 = { class: "input-wrapper" };
const _hoisted_20$1 = ["disabled"];
const _hoisted_21$1 = { class: "form-row" };
const _hoisted_22$1 = { class: "form-group half" };
const _hoisted_23$1 = { class: "label-input-row" };
const _hoisted_24$1 = { class: "input-wrapper" };
const _hoisted_25$1 = ["disabled"];
const _hoisted_26$1 = {
  key: 0,
  class: "field-hint error"
};
const _hoisted_27$1 = { class: "form-group half" };
const _hoisted_28$1 = { class: "label-input-row right-label" };
const _hoisted_29$1 = { class: "input-wrapper" };
const _hoisted_30$1 = ["disabled"];
const _hoisted_31$1 = {
  key: 0,
  class: "field-hint error"
};
const _hoisted_32$1 = { class: "button-wrapper" };
const _hoisted_33$1 = ["disabled"];
const _hoisted_34$1 = {
  key: 0,
  class: "btn-content"
};
const _hoisted_35$1 = {
  key: 1,
  class: "btn-content"
};
const _hoisted_36$1 = { class: "form-footer" };
const _hoisted_37$1 = { class: "login-link" };
const _sfc_main$8 = /* @__PURE__ */ defineComponent({
  __name: "Register",
  emits: ["switchToLogin", "registerSuccess"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    const taobaoId = ref("");
    const shopName = ref("");
    const userCode = ref("");
    const userName = ref("");
    const password = ref("");
    const confirmPassword = ref("");
    const loading = ref(false);
    const isFormValid = computed(() => {
      return taobaoId.value.trim() !== "" && shopName.value.trim() !== "" && userCode.value.trim() !== "" && userName.value.trim() !== "" && password.value.trim() !== "" && confirmPassword.value.trim() !== "" && password.value === confirmPassword.value && password.value.length >= 6;
    });
    const handleRegister = () => __async(this, null, function* () {
      if (!isFormValid.value) {
        alert("请检查输入信息");
        return;
      }
      if (password.value !== confirmPassword.value) {
        alert("两次输入的密码不一致");
        return;
      }
      loading.value = true;
      try {
        const registerData = {
          taobaoId: taobaoId.value.trim(),
          shopName: shopName.value.trim(),
          userCode: userCode.value.trim(),
          userName: userName.value.trim(),
          password: password.value
        };
        console.log("开始注册:", {
          taobaoId: registerData.taobaoId,
          shopName: registerData.shopName,
          userCode: registerData.userCode,
          userName: registerData.userName,
          password: "***"
        });
        const response = yield registerAPI(registerData);
        console.log("注册API响应:", response);
        if (response.code === "0") {
          console.log("注册成功");
          emit("registerSuccess", {
            taobaoId: registerData.taobaoId,
            shopName: registerData.shopName,
            userCode: registerData.userCode,
            userName: registerData.userName
          });
          taobaoId.value = "";
          shopName.value = "";
          userCode.value = "";
          userName.value = "";
          password.value = "";
          confirmPassword.value = "";
          alert("注册成功！请登录");
        } else {
          throw new Error(response.msg || "注册失败");
        }
      } catch (error) {
        console.error("注册失败:", error);
        const errorMessage = error instanceof Error ? error.message : "注册失败，请重试";
        alert(errorMessage);
      } finally {
        loading.value = false;
      }
    });
    const switchToLogin = () => {
      emit("switchToLogin");
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$8, [
        createBaseVNode("div", _hoisted_2$7, [
          _cache[22] || (_cache[22] = createBaseVNode("div", { class: "form-header" }, [
            createBaseVNode("h2", { class: "register-title" }, "创建新账户"),
            createBaseVNode("p", { class: "register-subtitle" }, "加入我们，开始您的数据管理之旅")
          ], -1)),
          createBaseVNode("form", {
            onSubmit: withModifiers(handleRegister, ["prevent"]),
            class: "form"
          }, [
            createBaseVNode("div", _hoisted_3$7, [
              createBaseVNode("div", _hoisted_4$5, [
                createBaseVNode("div", _hoisted_5$5, [
                  _cache[7] || (_cache[7] = createBaseVNode("label", { for: "taobaoId" }, [
                    createBaseVNode("span", { class: "label-icon" }, "🛒"),
                    createTextVNode(" 淘宝ID ")
                  ], -1)),
                  createBaseVNode("div", _hoisted_6$5, [
                    withDirectives(createBaseVNode("input", {
                      id: "taobaoId",
                      "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => taobaoId.value = $event),
                      type: "text",
                      placeholder: "请输入淘宝ID",
                      required: "",
                      disabled: loading.value,
                      class: "form-input"
                    }, null, 8, _hoisted_7$5), [
                      [vModelText, taobaoId.value]
                    ]),
                    _cache[6] || (_cache[6] = createBaseVNode("div", { class: "input-border" }, null, -1))
                  ])
                ])
              ]),
              createBaseVNode("div", _hoisted_8$4, [
                createBaseVNode("div", _hoisted_9$4, [
                  _cache[9] || (_cache[9] = createBaseVNode("label", { for: "shopName" }, [
                    createBaseVNode("span", { class: "label-icon" }, "🏪"),
                    createTextVNode(" 店铺名称 ")
                  ], -1)),
                  createBaseVNode("div", _hoisted_10$4, [
                    withDirectives(createBaseVNode("input", {
                      id: "shopName",
                      "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => shopName.value = $event),
                      type: "text",
                      placeholder: "请输入店铺名称",
                      required: "",
                      disabled: loading.value,
                      class: "form-input"
                    }, null, 8, _hoisted_11$4), [
                      [vModelText, shopName.value]
                    ]),
                    _cache[8] || (_cache[8] = createBaseVNode("div", { class: "input-border" }, null, -1))
                  ])
                ])
              ])
            ]),
            createBaseVNode("div", _hoisted_12$2, [
              createBaseVNode("div", _hoisted_13$2, [
                createBaseVNode("div", _hoisted_14$2, [
                  _cache[11] || (_cache[11] = createBaseVNode("label", { for: "userCode" }, [
                    createBaseVNode("span", { class: "label-icon" }, "👤"),
                    createTextVNode(" 账号 ")
                  ], -1)),
                  createBaseVNode("div", _hoisted_15$1, [
                    withDirectives(createBaseVNode("input", {
                      id: "userCode",
                      "onUpdate:modelValue": _cache[2] || (_cache[2] = ($event) => userCode.value = $event),
                      type: "text",
                      placeholder: "请输入用户编码",
                      required: "",
                      disabled: loading.value,
                      class: "form-input"
                    }, null, 8, _hoisted_16$1), [
                      [vModelText, userCode.value]
                    ]),
                    _cache[10] || (_cache[10] = createBaseVNode("div", { class: "input-border" }, null, -1))
                  ])
                ])
              ]),
              createBaseVNode("div", _hoisted_17$1, [
                createBaseVNode("div", _hoisted_18$1, [
                  _cache[13] || (_cache[13] = createBaseVNode("label", { for: "userName" }, [
                    createBaseVNode("span", { class: "label-icon" }, "📝"),
                    createTextVNode(" 用户昵称 ")
                  ], -1)),
                  createBaseVNode("div", _hoisted_19$1, [
                    withDirectives(createBaseVNode("input", {
                      id: "userName",
                      "onUpdate:modelValue": _cache[3] || (_cache[3] = ($event) => userName.value = $event),
                      type: "text",
                      placeholder: "请输入用户名称",
                      required: "",
                      disabled: loading.value,
                      class: "form-input"
                    }, null, 8, _hoisted_20$1), [
                      [vModelText, userName.value]
                    ]),
                    _cache[12] || (_cache[12] = createBaseVNode("div", { class: "input-border" }, null, -1))
                  ])
                ])
              ])
            ]),
            createBaseVNode("div", _hoisted_21$1, [
              createBaseVNode("div", _hoisted_22$1, [
                createBaseVNode("div", _hoisted_23$1, [
                  _cache[15] || (_cache[15] = createBaseVNode("label", { for: "password" }, [
                    createBaseVNode("span", { class: "label-icon" }, "🔒"),
                    createTextVNode(" 密码 ")
                  ], -1)),
                  createBaseVNode("div", _hoisted_24$1, [
                    withDirectives(createBaseVNode("input", {
                      id: "password",
                      "onUpdate:modelValue": _cache[4] || (_cache[4] = ($event) => password.value = $event),
                      type: "password",
                      placeholder: "请输入密码（至少6位）",
                      required: "",
                      disabled: loading.value,
                      class: normalizeClass(["form-input", { "input-error": password.value && password.value.length < 6 }])
                    }, null, 10, _hoisted_25$1), [
                      [vModelText, password.value]
                    ]),
                    _cache[14] || (_cache[14] = createBaseVNode("div", { class: "input-border" }, null, -1))
                  ])
                ]),
                password.value && password.value.length < 6 ? (openBlock(), createElementBlock("div", _hoisted_26$1, " 密码长度至少6位 ")) : createCommentVNode("", true)
              ]),
              createBaseVNode("div", _hoisted_27$1, [
                createBaseVNode("div", _hoisted_28$1, [
                  _cache[17] || (_cache[17] = createBaseVNode("label", { for: "confirmPassword" }, [
                    createBaseVNode("span", { class: "label-icon" }, "🔐"),
                    createTextVNode(" 确认密码 ")
                  ], -1)),
                  createBaseVNode("div", _hoisted_29$1, [
                    withDirectives(createBaseVNode("input", {
                      id: "confirmPassword",
                      "onUpdate:modelValue": _cache[5] || (_cache[5] = ($event) => confirmPassword.value = $event),
                      type: "password",
                      placeholder: "请再次输入密码",
                      required: "",
                      disabled: loading.value,
                      class: normalizeClass(["form-input", { "input-error": confirmPassword.value && password.value !== confirmPassword.value }])
                    }, null, 10, _hoisted_30$1), [
                      [vModelText, confirmPassword.value]
                    ]),
                    _cache[16] || (_cache[16] = createBaseVNode("div", { class: "input-border" }, null, -1))
                  ])
                ]),
                confirmPassword.value && password.value !== confirmPassword.value ? (openBlock(), createElementBlock("div", _hoisted_31$1, " 两次密码不一致 ")) : createCommentVNode("", true)
              ])
            ]),
            createBaseVNode("div", _hoisted_32$1, [
              createBaseVNode("button", {
                type: "submit",
                class: normalizeClass(["register-btn", { "loading": loading.value }]),
                disabled: loading.value || !isFormValid.value
              }, [
                loading.value ? (openBlock(), createElementBlock("span", _hoisted_34$1, [..._cache[18] || (_cache[18] = [
                  createBaseVNode("div", { class: "loading-spinner" }, null, -1),
                  createTextVNode(" 注册中... ", -1)
                ])])) : (openBlock(), createElementBlock("span", _hoisted_35$1, [..._cache[19] || (_cache[19] = [
                  createBaseVNode("span", { class: "btn-icon" }, "✨", -1),
                  createTextVNode(" 立即注册 ", -1)
                ])]))
              ], 10, _hoisted_33$1)
            ])
          ], 32),
          createBaseVNode("div", _hoisted_36$1, [
            createBaseVNode("p", _hoisted_37$1, [
              _cache[21] || (_cache[21] = createTextVNode(" 已有账号？ ", -1)),
              createBaseVNode("a", {
                href: "#",
                onClick: withModifiers(switchToLogin, ["prevent"]),
                class: "login-btn"
              }, [..._cache[20] || (_cache[20] = [
                createBaseVNode("span", { class: "login-icon" }, "👋", -1),
                createTextVNode(" 立即登录 ", -1)
              ])])
            ])
          ])
        ])
      ]);
    };
  }
});
const Register = /* @__PURE__ */ _export_sfc(_sfc_main$8, [["__scopeId", "data-v-0ab985ce"]]);
const _hoisted_1$7 = { class: "ad-container" };
const _hoisted_2$6 = { class: "carousel-wrapper" };
const _hoisted_3$6 = ["src", "alt"];
const _hoisted_4$4 = { class: "carousel-indicators" };
const _hoisted_5$4 = ["onClick"];
const _hoisted_6$4 = ["disabled"];
const _hoisted_7$4 = ["disabled"];
const _hoisted_8$3 = { class: "ad-footer" };
const _hoisted_9$3 = { class: "login-tip" };
const _hoisted_10$3 = { class: "payment-content" };
const _hoisted_11$3 = { class: "price-options" };
const _sfc_main$7 = /* @__PURE__ */ defineComponent({
  __name: "AdPage",
  emits: ["continue-basic", "back-to-login"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    const slides = ref([
      {
        title: "智能数据分析",
        description: "深度分析您的店铺数据，提供精准的营销建议和运营策略",
        image: "data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMzAwIiBoZWlnaHQ9IjIwMCIgdmlld0JveD0iMCAwIDMwMCAyMDAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIzMDAiIGhlaWdodD0iMjAwIiBmaWxsPSIjRjVGNUY3Ii8+CjxyZWN0IHg9IjUwIiB5PSI1MCIgd2lkdGg9IjIwMCIgaGVpZ2h0PSIxMDAiIGZpbGw9IiM2NjdFRUEiIHJ4PSI4Ii8+Cjx0ZXh0IHg9IjE1MCIgeT0iMTEwIiB0ZXh0LWFuY2hvcj0ibWlkZGxlIiBmaWxsPSJ3aGl0ZSIgZm9udC1mYW1pbHk9IkFyaWFsIiBmb250LXNpemU9IjE0Ij7mmbrog73mlbDmja7liqDovb3lpLHotKU8L3RleHQ+Cjwvc3ZnPgo="
      },
      {
        title: "实时数据同步",
        description: "自动同步生意参谋和万相台数据，实时掌握店铺运营状况",
        image: "data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMzAwIiBoZWlnaHQ9IjIwMCIgdmlld0JveD0iMCAwIDMwMCAyMDAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIzMDAiIGhlaWdodD0iMjAwIiBmaWxsPSIjRjVGNUY3Ii8+CjxjaXJjbGUgY3g9IjE1MCIgY3k9IjEwMCIgcj0iNDAiIGZpbGw9IiM2NjdFRUEiLz4KPHBhdGggZD0iTTEzMCAxMDBMMTUwIDgwTDE3MCAxMDAiIHN0cm9rZT0id2hpdGUiIHN0cm9rZS13aWR0aD0iNCIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjx0ZXh0IHg9IjE1MCIgeT0iMTYwIiB0ZXh0LWFuY2hvcj0ibWlkZGxlIiBmaWxsPSIjMzMzIiBmb250LWZhbWlseT0iQXJpYWwiIGZvbnQtc2l6ZT0iMTQiPuWKoOi9veWKoOivveWksei0pTwvdGV4dD4KPC9zdmc+Cg=="
      },
      {
        title: "精准营销工具",
        description: "基于AI算法的精准营销策略推荐，提升转化率和ROI",
        image: "data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMzAwIiBoZWlnaHQ9IjIwMCIgdmlld0JveD0iMCAwIDMwMCAyMDAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIzMDAiIGhlaWdodD0iMjAwIiBmaWxsPSIjRjVGNUY3Ii8+CjxwYXRoIGQ9Ik0xNTAgNDBMMTgwIDgwTDE1MCAxMjBMMTIwIDgwWiIgZmlsbD0iIzY2N0VFQSIvPgo8Y2lyY2xlIGN4PSIxNTAiIGN5PSI4MCIgcj0iMjAiIGZpbGw9IndoaXRlIi8+Cjx0ZXh0IHg9IjE1MCIgeT0iMTYwIiB0ZXh0LWFuY2hvcj0ibWlkZGxlIiBmaWxsPSIjMzMzIiBmb250LWZhbWlseT0iQXJpYWwiIGZvbnQtc2l6ZT0iMTQiPuWKoOi9veWksei0pemHj+WKoOivvTwvdGV4dD4KPC9zdmc+Cg=="
      },
      {
        title: "专业运营助手",
        description: "一站式电商运营工具集合，让您的店铺运营更高效",
        image: "data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMzAwIiBoZWlnaHQ9IjIwMCIgdmlld0JveD0iMCAwIDMwMCAyMDAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIzMDAiIGhlaWdodD0iMjAwIiBmaWxsPSIjRjVGNUY3Ii8+CjxyZWN0IHg9IjgwIiB5PSI2MCIgd2lkdGg9IjE0MCIgaGVpZ2h0PSI4MCIgZmlsbD0iIzY2N0VFQSIgcng9IjEwIi8+Cjx0ZXh0IHg9IjE1MCIgeT0iMTEwIiB0ZXh0LWFuY2hvcj0ibWlkZGxlIiBmaWxsPSJ3aGl0ZSIgZm9udC1mYW1pbHk9IkFyaWFsIiBmb250LXNpemU9IjE0Ij7liqDovb3lupTnlKjmiJHnmoTnlKjmiL88L3RleHQ+Cjwvc3ZnPgo="
      }
    ]);
    const currentSlide = ref(0);
    const previousSlide = ref(0);
    const isTransitioning = ref(false);
    const carouselContainer = ref();
    let autoPlayTimer = null;
    const showPaymentModal = ref(false);
    const selectedPlan = ref("yearly");
    const goToSlide = (index) => {
      if (isTransitioning.value || index === currentSlide.value) return;
      isTransitioning.value = true;
      previousSlide.value = currentSlide.value;
      currentSlide.value = index;
      setTimeout(() => {
        isTransitioning.value = false;
      }, 300);
    };
    const nextSlide = () => {
      const nextIndex = (currentSlide.value + 1) % slides.value.length;
      goToSlide(nextIndex);
    };
    const prevSlide = () => {
      const prevIndex = currentSlide.value === 0 ? slides.value.length - 1 : currentSlide.value - 1;
      goToSlide(prevIndex);
    };
    const startAutoPlay = () => {
      autoPlayTimer = window.setInterval(() => {
        nextSlide();
      }, 4e3);
    };
    const stopAutoPlay = () => {
      if (autoPlayTimer) {
        clearInterval(autoPlayTimer);
        autoPlayTimer = null;
      }
    };
    const handleUpgrade = () => {
      console.log("用户点击升级");
      showPaymentModal.value = true;
    };
    const selectPlan = (plan) => {
      selectedPlan.value = plan;
    };
    const closePaymentModal = () => {
      showPaymentModal.value = false;
    };
    const handleLogin = () => {
      emit("back-to-login");
    };
    onMounted(() => {
      startAutoPlay();
    });
    onUnmounted(() => {
      stopAutoPlay();
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$7, [
        createBaseVNode("div", _hoisted_2$6, [
          createBaseVNode("div", {
            class: "carousel-container",
            ref_key: "carouselContainer",
            ref: carouselContainer
          }, [
            (openBlock(true), createElementBlock(Fragment, null, renderList(slides.value, (slide, index) => {
              return openBlock(), createElementBlock("div", {
                class: normalizeClass(["carousel-slide", {
                  active: currentSlide.value === index,
                  prev: previousSlide.value === index && isTransitioning.value
                }]),
                key: index
              }, [
                createBaseVNode("img", {
                  src: slide.image,
                  alt: slide.title,
                  class: "slide-image"
                }, null, 8, _hoisted_3$6)
              ], 2);
            }), 128))
          ], 512),
          createBaseVNode("div", _hoisted_4$4, [
            (openBlock(true), createElementBlock(Fragment, null, renderList(slides.value, (slide, index) => {
              return openBlock(), createElementBlock("span", {
                key: index,
                class: normalizeClass(["indicator", { active: currentSlide.value === index }]),
                onClick: ($event) => goToSlide(index)
              }, null, 10, _hoisted_5$4);
            }), 128))
          ]),
          createBaseVNode("button", {
            class: "carousel-btn prev",
            onClick: prevSlide,
            disabled: isTransitioning.value
          }, " ‹ ", 8, _hoisted_6$4),
          createBaseVNode("button", {
            class: "carousel-btn next",
            onClick: nextSlide,
            disabled: isTransitioning.value
          }, " › ", 8, _hoisted_7$4)
        ]),
        createBaseVNode("div", _hoisted_8$3, [
          createBaseVNode("button", {
            class: "upgrade-btn",
            onClick: handleUpgrade
          }, " 立即升级专业版 "),
          createBaseVNode("p", _hoisted_9$3, [
            _cache[3] || (_cache[3] = createTextVNode("已有专业版账户？", -1)),
            createBaseVNode("a", {
              href: "#",
              onClick: withModifiers(handleLogin, ["prevent"])
            }, "重新登录")
          ])
        ]),
        showPaymentModal.value ? (openBlock(), createElementBlock("div", {
          key: 0,
          class: "payment-modal-overlay",
          onClick: closePaymentModal
        }, [
          createBaseVNode("div", {
            class: "payment-modal",
            onClick: _cache[2] || (_cache[2] = withModifiers(() => {
            }, ["stop"]))
          }, [
            createBaseVNode("div", { class: "payment-header" }, [
              _cache[4] || (_cache[4] = createBaseVNode("h3", null, "升级到专业版", -1)),
              createBaseVNode("button", {
                class: "close-btn",
                onClick: closePaymentModal
              }, "×")
            ]),
            createBaseVNode("div", _hoisted_10$3, [
              createBaseVNode("div", _hoisted_11$3, [
                createBaseVNode("div", {
                  class: normalizeClass(["price-option", { active: selectedPlan.value === "monthly" }]),
                  onClick: _cache[0] || (_cache[0] = ($event) => selectPlan("monthly"))
                }, [..._cache[5] || (_cache[5] = [
                  createBaseVNode("div", { class: "plan-name" }, "单月套餐", -1),
                  createBaseVNode("div", { class: "plan-price" }, [
                    createTextVNode("¥29"),
                    createBaseVNode("span", { class: "price-unit" }, "/月")
                  ], -1),
                  createBaseVNode("div", { class: "plan-desc" }, "适合短期使用", -1)
                ])], 2),
                createBaseVNode("div", {
                  class: normalizeClass(["price-option recommended", { active: selectedPlan.value === "yearly" }]),
                  onClick: _cache[1] || (_cache[1] = ($event) => selectPlan("yearly"))
                }, [..._cache[6] || (_cache[6] = [
                  createStaticVNode('<div class="recommend-badge" data-v-4db27fe0>推荐</div><div class="plan-name" data-v-4db27fe0>包年套餐</div><div class="plan-price" data-v-4db27fe0>¥299<span class="price-unit" data-v-4db27fe0>/年</span></div><div class="plan-desc" data-v-4db27fe0>节省 ¥49，相当于 ¥25/月</div>', 4)
                ])], 2)
              ]),
              _cache[7] || (_cache[7] = createBaseVNode("div", { class: "payment-qr" }, [
                createBaseVNode("h4", null, "扫码支付"),
                createBaseVNode("div", { class: "qr-container" }, [
                  createBaseVNode("img", {
                    src: "data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAwIiBoZWlnaHQ9IjIwMCIgdmlld0JveD0iMCAwIDIwMCAyMDAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIyMDAiIGhlaWdodD0iMjAwIiBmaWxsPSJ3aGl0ZSIvPgo8cmVjdCB4PSIxMCIgeT0iMTAiIHdpZHRoPSIxODAiIGhlaWdodD0iMTgwIiBzdHJva2U9IiMwMDAiIHN0cm9rZS13aWR0aD0iMiIvPgo8cmVjdCB4PSIyMCIgeT0iMjAiIHdpZHRoPSI0MCIgaGVpZ2h0PSI0MCIgZmlsbD0iIzAwMCIvPgo8cmVjdCB4PSIxNDAiIHk9IjIwIiB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIGZpbGw9IiMwMDAiLz4KPHJlY3QgeD0iMjAiIHk9IjE0MCIgd2lkdGg9IjQwIiBoZWlnaHQ9IjQwIiBmaWxsPSIjMDAwIi8+CjxyZWN0IHg9IjgwIiB5PSI4MCIgd2lkdGg9IjQwIiBoZWlnaHQ9IjQwIiBmaWxsPSIjMDAwIi8+CjxyZWN0IHg9IjEyMCIgeT0iODAiIHdpZHRoPSI0MCIgaGVpZ2h0PSI0MCIgZmlsbD0iIzAwMCIvPgo8cmVjdCB4PSI4MCIgeT0iMTIwIiB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIGZpbGw9IiMwMDAiLz4KPHJlY3QgeD0iMTIwIiB5PSIxMjAiIHdpZHRoPSI0MCIgaGVpZ2h0PSI0MCIgZmlsbD0iIzAwMCIvPgo8dGV4dCB4PSIxMDAiIHk9IjE5MCIgdGV4dC1hbmNob3I9Im1pZGRsZSIgZmlsbD0iIzMzMyIgZm9udC1mYW1pbHk9IkFyaWFsIiBmb250LXNpemU9IjEyIj7mlK/ku5jmiJbogIU8L3RleHQ+Cjwvc3ZnPgo=",
                    alt: "支付二维码",
                    class: "qr-code"
                  })
                ]),
                createBaseVNode("p", { class: "qr-tip" }, "请使用微信或支付宝扫码支付")
              ], -1))
            ])
          ])
        ])) : createCommentVNode("", true)
      ]);
    };
  }
});
const AdPage = /* @__PURE__ */ _export_sfc(_sfc_main$7, [["__scopeId", "data-v-4db27fe0"]]);
const dialogState = ref({
  visible: false,
  type: "info",
  title: "",
  message: "",
  confirmText: "确定",
  cancelText: "取消",
  loadingText: "处理中...",
  showCancel: false,
  loading: false,
  allowOverlayClose: false
});
let eventHandlers = {};
class UnifiedDialogManager {
  // 显示弹窗
  static show(config) {
    dialogState.value = {
      visible: true,
      type: config.type,
      title: config.title || this.getDefaultTitle(config.type),
      message: config.message,
      confirmText: config.confirmText || "确定",
      cancelText: config.cancelText || "取消",
      loadingText: config.loadingText || "处理中...",
      showCancel: config.showCancel || false,
      loading: false,
      allowOverlayClose: config.allowOverlayClose || false
    };
    eventHandlers = {
      onConfirm: config.onConfirm,
      onCancel: config.onCancel,
      onClose: config.onClose
    };
  }
  // 隐藏弹窗
  static hide() {
    dialogState.value.visible = false;
    eventHandlers = {};
  }
  // 设置加载状态
  static setLoading(loading) {
    dialogState.value.loading = loading;
  }
  // 获取默认标题
  static getDefaultTitle(type) {
    switch (type) {
      case "warning":
        return "确认操作";
      case "error":
        return "操作异常";
      case "success":
        return "操作成功";
      case "info":
        return "提示信息";
      default:
        return "提示";
    }
  }
  // 获取状态
  static getState() {
    return dialogState;
  }
  // 获取事件处理器
  static getEventHandlers() {
    return eventHandlers;
  }
  // 处理确认事件
  static handleConfirm() {
    return __async(this, null, function* () {
      if (eventHandlers.onConfirm) {
        try {
          yield eventHandlers.onConfirm();
        } catch (error) {
          console.error("确认事件处理失败:", error);
        }
      }
    });
  }
  // 处理取消事件
  static handleCancel() {
    if (eventHandlers.onCancel) {
      eventHandlers.onCancel();
    }
    this.hide();
  }
  // 处理关闭事件
  static handleClose() {
    if (eventHandlers.onClose) {
      eventHandlers.onClose();
    }
    this.hide();
  }
  // 便捷方法 - 显示警告弹窗
  static showWarning(message, config) {
    this.show(__spreadValues({
      type: "warning",
      message,
      showCancel: true
    }, config));
  }
  // 便捷方法 - 显示错误弹窗
  static showError(message, config) {
    this.show(__spreadValues({
      type: "error",
      message
    }, config));
  }
  // 便捷方法 - 显示成功弹窗
  static showSuccess(message, config) {
    this.show(__spreadValues({
      type: "success",
      message
    }, config));
  }
  // 便捷方法 - 显示信息弹窗
  static showInfo(message, config) {
    this.show(__spreadValues({
      type: "info",
      message
    }, config));
  }
}
const unifiedDialogManager = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  UnifiedDialogManager,
  dialogState
}, Symbol.toStringTag, { value: "Module" }));
function useChromeAPI() {
  const sendMessageToContent2 = (message, timeout = 12e4, maxRetries = 3) => {
    return new Promise((resolve, reject) => {
      let retryCount = 0;
      const attemptSendMessage = () => {
        const timeoutId = setTimeout(() => {
          reject(new Error("消息发送超时，请检查页面是否正常加载"));
        }, timeout);
        chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
          var _a, _b, _c, _d, _e;
          if (chrome.runtime.lastError) {
            clearTimeout(timeoutId);
            reject(chrome.runtime.lastError);
            return;
          }
          if (!tabs[0]) {
            clearTimeout(timeoutId);
            reject(new Error("未找到活动标签页"));
            return;
          }
          const tab = tabs[0];
          if (((_a = tab.url) == null ? void 0 : _a.startsWith("chrome://")) || ((_b = tab.url) == null ? void 0 : _b.startsWith("chrome-extension://")) || ((_c = tab.url) == null ? void 0 : _c.startsWith("moz-extension://")) || ((_d = tab.url) == null ? void 0 : _d.startsWith("edge://")) || ((_e = tab.url) == null ? void 0 : _e.startsWith("about:"))) {
            clearTimeout(timeoutId);
            reject(new Error("无法在此页面执行操作（特殊页面）"));
            return;
          }
          const sendMessageWithErrorHandling = () => {
            console.log("🔍 [CHROME-API] 开始发送消息流程，目标tabId:", tab.id);
            console.log("🔍 [CHROME-API] 要发送的消息:", message);
            console.log("📡 [CHROME-API] 直接发送实际消息...");
            chrome.tabs.sendMessage(tab.id, message, (response) => {
              var _a2, _b2, _c2, _d2, _e2, _f;
              clearTimeout(timeoutId);
              console.log("🔍 [CHROME-API] 发送消息后的响应:", response);
              console.log("🔍 [CHROME-API] 发送消息后的响应:", chrome.runtime);
              if (chrome.runtime.lastError) {
                const error = chrome.runtime.lastError;
                console.log(`消息发送失败 (尝试 ${retryCount + 1}/${maxRetries + 1}):`, error.message);
                if (((_a2 = error.message) == null ? void 0 : _a2.includes("Receiving end does not exist")) || ((_b2 = error.message) == null ? void 0 : _b2.includes("The message port closed before a response was received")) || ((_c2 = error.message) == null ? void 0 : _c2.includes("Could not establish connection"))) {
                  if (retryCount < maxRetries) {
                    retryCount++;
                    console.log(`尝试重新注入content script (第${retryCount}次重试)`);
                    chrome.scripting.executeScript({
                      target: { tabId: tab.id },
                      files: ["content.js"]
                    }).then(() => {
                      console.log("Content script重新注入成功，等待初始化...");
                      setTimeout(attemptSendMessage, 3e3);
                    }).catch((injectError) => {
                      console.log("Content script重新注入失败:", injectError);
                      setTimeout(attemptSendMessage, 1e3);
                    });
                    return;
                  } else {
                    if ((_d2 = error.message) == null ? void 0 : _d2.includes("Receiving end does not exist")) {
                      reject(new Error("Content script未加载，请刷新页面后重试"));
                    } else if ((_e2 = error.message) == null ? void 0 : _e2.includes("The message port closed before a response was received")) {
                      reject(new Error("消息端口已关闭，可能是页面刷新或导航导致。请刷新页面后重试"));
                    } else if ((_f = error.message) == null ? void 0 : _f.includes("Could not establish connection")) {
                      reject(new Error("无法建立连接，请检查页面是否正常加载"));
                    } else {
                      reject(error);
                    }
                    return;
                  }
                } else {
                  reject(error);
                  return;
                }
              } else {
                console.log("✅ [CHROME-API] 消息发送成功，响应:", response);
                resolve(response);
              }
            });
          };
          if (retryCount === 0) {
            chrome.scripting.executeScript({
              target: { tabId: tab.id },
              files: ["content.js"]
            }).then(() => {
              console.log("Content script注入成功");
              setTimeout(sendMessageWithErrorHandling, 3e3);
            }).catch((injectError) => {
              console.log("Content script注入失败，尝试直接发送消息:", injectError);
              setTimeout(sendMessageWithErrorHandling, 1e3);
            });
          } else {
            console.log("🔄 [CHROME-API] 重试时重新注入Content script");
            chrome.scripting.executeScript({
              target: { tabId: tab.id },
              files: ["content.js"]
            }).then(() => {
              console.log("✅ [CHROME-API] 重试时Content script注入成功");
              setTimeout(sendMessageWithErrorHandling, 2e3);
            }).catch((injectError) => {
              console.log("⚠️ [CHROME-API] 重试时Content script注入失败，尝试直接发送消息:", injectError);
              setTimeout(sendMessageWithErrorHandling, 1e3);
            });
          }
        });
      };
      attemptSendMessage();
    });
  };
  return {
    sendMessageToContent: sendMessageToContent2
  };
}
class PageNavigationUtils {
  /**
   * 跳转到指定页面并等待页面加载完成
   * @param url 目标页面URL
   * @param options 配置选项
   * @returns Promise<void>
   */
  static navigateToPage(_0) {
    return __async(this, arguments, function* (url, options = {}) {
      const {
        checkInterval = 500,
        urlContains
      } = options;
      console.log("📍 [PAGE-NAV] 开始跳转到页面:", url);
      console.log("📍 [PAGE-NAV] 配置选项:", { checkInterval, urlContains });
      try {
        console.log("📍 [PAGE-NAV] 步骤1：执行页面跳转");
        yield this.navigateToUrl(url);
        console.log("✅ [PAGE-NAV] 页面跳转完成");
        console.log("📍 [PAGE-NAV] 步骤2：获取当前标签页ID");
        const tabId = yield this.getCurrentTabId();
        console.log("✅ [PAGE-NAV] 获取到标签页ID:", tabId);
        console.log("📍 [PAGE-NAV] 步骤3：等待页面加载完成");
        yield this.waitForPageLoadComplete(tabId, { checkInterval, urlContains });
        console.log("✅ [PAGE-NAV] 页面加载等待完成");
      } catch (error) {
        console.error("❌ [PAGE-NAV] 页面导航过程中发生错误:", error);
        throw error;
      }
    });
  }
  /**
   * 跳转到指定URL（基于现有实现）
   * @param url 目标URL
   * @returns Promise<void>
   */
  static navigateToUrl(url) {
    return __async(this, null, function* () {
      return new Promise((resolve, reject) => {
        console.log("🔍 [PAGE-NAV] 查询当前活动标签页...");
        chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
          console.log("🔍 [PAGE-NAV] 查询结果:", { tabsCount: tabs.length, tabs });
          if (chrome.runtime.lastError) {
            console.error("❌ [PAGE-NAV] 查询标签页失败:", chrome.runtime.lastError);
            reject(chrome.runtime.lastError);
          } else if (tabs[0] && tabs[0].id) {
            console.log("🔍 [PAGE-NAV] 找到活动标签页，ID:", tabs[0].id, "当前URL:", tabs[0].url);
            console.log("🔍 [PAGE-NAV] 准备更新标签页URL到:", url);
            chrome.tabs.update(tabs[0].id, { url }, () => {
              if (chrome.runtime.lastError) {
                console.error("❌ [PAGE-NAV] 更新标签页URL失败:", chrome.runtime.lastError);
                reject(chrome.runtime.lastError);
              } else {
                console.log("✅ [PAGE-NAV] 页面跳转成功");
                resolve();
              }
            });
          } else {
            console.error("❌ [PAGE-NAV] 未找到活动标签页");
            reject(new Error("未找到活动标签页"));
          }
        });
      });
    });
  }
  /**
   * 获取当前标签页ID
   * @returns Promise<number>
   */
  static getCurrentTabId() {
    return __async(this, null, function* () {
      return new Promise((resolve, reject) => {
        console.log("🔍 [PAGE-NAV] 获取当前标签页ID...");
        chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
          console.log("🔍 [PAGE-NAV] 获取标签页ID查询结果:", { tabsCount: tabs.length });
          if (chrome.runtime.lastError) {
            console.error("❌ [PAGE-NAV] 获取标签页ID失败:", chrome.runtime.lastError);
            reject(chrome.runtime.lastError);
          } else if (tabs[0] && tabs[0].id) {
            console.log("✅ [PAGE-NAV] 获取到标签页ID:", tabs[0].id);
            resolve(tabs[0].id);
          } else {
            console.error("❌ [PAGE-NAV] 未找到活动标签页");
            reject(new Error("未找到活动标签页"));
          }
        });
      });
    });
  }
  /**
   * 等待页面加载完成（基于现有实现）
   * @param tabId 标签页ID
   * @param options 配置选项
   * @returns Promise<void>
   */
  static waitForPageLoadComplete(_0) {
    return __async(this, arguments, function* (tabId, options = {}) {
      const { checkInterval = 500, urlContains } = options;
      console.log("🔍 [PAGE-NAV] 开始等待页面加载完成，参数:", { tabId, checkInterval, urlContains });
      return new Promise((resolve, reject) => {
        let checkCount = 0;
        const checkComplete = () => {
          checkCount++;
          console.log(`🔍 [PAGE-NAV] 第${checkCount}次检查页面加载状态...`);
          chrome.tabs.get(tabId, (tab) => {
            if (chrome.runtime.lastError) {
              console.error("❌ [PAGE-NAV] 获取标签页状态失败:", chrome.runtime.lastError);
              reject(chrome.runtime.lastError);
              return;
            }
            console.log(`🔍 [PAGE-NAV] 第${checkCount}次检查结果:`, {
              tabId: tab.id,
              status: tab.status,
              url: tab.url,
              title: tab.title
            });
            if (tab.status === "complete") {
              console.log("✅ [PAGE-NAV] 页面状态为complete");
              if (urlContains) {
                console.log("🔍 [PAGE-NAV] 检查URL是否包含:", urlContains);
                if (tab.url && tab.url.includes(urlContains)) {
                  console.log("✅ [PAGE-NAV] 页面加载完成，URL匹配:", tab.url);
                  resolve();
                } else {
                  console.log("⏳ [PAGE-NAV] 页面加载完成，但URL不匹配，继续等待...");
                  console.log("🔍 [PAGE-NAV] 期望URL包含:", urlContains);
                  console.log("🔍 [PAGE-NAV] 实际URL:", tab.url);
                  setTimeout(checkComplete, checkInterval);
                }
              } else {
                console.log("✅ [PAGE-NAV] 页面加载完成:", tab.url);
                resolve();
              }
            } else {
              console.log(`⏳ [PAGE-NAV] 页面加载中，状态: ${tab.status}`);
              setTimeout(checkComplete, checkInterval);
            }
          });
        };
        console.log("🔍 [PAGE-NAV] 开始第一次检查...");
        checkComplete();
      });
    });
  }
}
const { sendMessageToContent } = useChromeAPI();
let isWxtSubmitExecuting = false;
const WXT_SUBMIT_CONFIG = {
  // 万相台URL（直接带搜索参数）
  WXT_URL: "https://one.alimama.com/index.html#!/manage/onesite?offset=0&searchKey=itemId&searchValue=",
  // 轮询间隔（毫秒）
  POLLING_INTERVAL: 200,
  // 最大轮询次数
  MAX_POLLING_COUNT: 50
};
function executeWxtSubmit(id, goodsId, suggestInputValue, dayBudgetValue) {
  return __async(this, null, function* () {
    if (isWxtSubmitExecuting) {
      console.log("⚠️ [WXT-SUBMIT] 万相台提交功能正在执行中，忽略重复请求");
      return {
        success: false,
        message: "万相台提交功能正在执行中，请勿重复操作",
        error: "功能正在执行中"
      };
    }
    isWxtSubmitExecuting = true;
    try {
      if (!goodsId) {
        throw new Error("商品ID不存在");
      }
      console.log("🚀 [WXT-SUBMIT] 使用商品ID:", goodsId);
      try {
        yield PageNavigationUtils.navigateToPage(WXT_SUBMIT_CONFIG.WXT_URL + goodsId, {
          urlContains: "one.alimama.com"
        });
        console.log("✅ [WXT-SUBMIT] 页面跳转完成，时间:", (/* @__PURE__ */ new Date()).toISOString());
      } catch (error) {
        console.error("❌ [WXT-SUBMIT] 页面跳转失败:", error);
        throw error;
      }
      console.log("📤 [WXT-SUBMIT] 开始分步骤执行万相台工作流");
      console.log("📤 [WXT-SUBMIT] 执行万相台提交工作流");
      console.log("📤 [WXT-SUBMIT] 发送msgWxtPromSubmit消息，时间:", (/* @__PURE__ */ new Date()).toISOString());
      try {
        const result = yield sendMessageToContent({
          action: "msgWxtPromSubmit",
          data: {
            suggestInputValue,
            // 自定义选项输入值
            dayBudgetValue
            // 日预算输入值
          }
        }, 6e4);
        console.log("📤 [WXT-SUBMIT] msgWxtPromSubmit消息响应:", result);
        if (!result || !result.success) {
          throw new Error((result == null ? void 0 : result.message) || "万相台提交工作流失败");
        }
        console.log("✅ [WXT-SUBMIT] 万相台提交工作流成功");
      } catch (error) {
        console.error("❌ [WXT-SUBMIT] 万相台提交工作流失败:", error);
        throw error;
      }
      try {
        const tokenResult = yield chrome.storage.local.get(["ecommerce_extension_token"]);
        if (!tokenResult.ecommerce_extension_token) {
          throw new Error("未找到认证token，请先登录");
        }
        yield updateEffectAPI(tokenResult.ecommerce_extension_token, { id });
      } catch (error) {
        console.error("❌ [WXT-SUBMIT] 后端同步状态更新异常:", error);
      }
      console.log("✅ [WXT-SUBMIT] 万相台提交功能执行成功");
      return {
        success: true,
        message: "万相台提交成功"
      };
    } catch (error) {
      console.error("❌ [WXT-SUBMIT] 万相台提交功能执行失败:", error);
      logError(error, "万相台提交功能", {
        additionalInfo: "万相台提交过程中发生错误"
      });
      const errorMessage = error instanceof Error ? error.message : "未知错误";
      const detailedMessage = `万相台提交失败: ${errorMessage}`;
      return {
        success: false,
        message: detailedMessage,
        error: errorMessage
      };
    } finally {
      isWxtSubmitExecuting = false;
      console.log("🔄 [WXT-SUBMIT] 万相台提交功能执行完成，重置状态标志");
    }
  });
}
const _hoisted_1$6 = { class: "plan-table-container" };
const _hoisted_2$5 = { class: "synced-status" };
const _hoisted_3$5 = { class: "status-info" };
const _hoisted_4$3 = { class: "count-text" };
const _hoisted_5$3 = {
  key: 0,
  class: "filtered-count-text"
};
const _hoisted_6$3 = { class: "action-buttons" };
const _hoisted_7$3 = ["disabled"];
const _hoisted_8$2 = {
  key: 0,
  class: "loading-container"
};
const _hoisted_9$2 = {
  key: 1,
  class: "wxt-submit-loading-overlay"
};
const _hoisted_10$2 = {
  key: 2,
  class: "error-container"
};
const _hoisted_11$2 = { class: "error-message" };
const _hoisted_12$1 = {
  key: 3,
  class: "table-wrapper"
};
const _hoisted_13$1 = { class: "table-header" };
const _hoisted_14$1 = { class: "header-cell checkbox-cell" };
const _hoisted_15 = ["checked"];
const _hoisted_16 = { class: "header-cell product-cell" };
const _hoisted_17 = { class: "product-header-content" };
const _hoisted_18 = { class: "product-header-row" };
const _hoisted_19 = { class: "search-container" };
const _hoisted_20 = {
  key: 0,
  style: { height: "0px" },
  class: "virtual-placeholder"
};
const _hoisted_21 = { class: "virtual-content" };
const _hoisted_22 = { class: "table-cell checkbox-cell" };
const _hoisted_23 = ["checked", "onChange", "disabled"];
const _hoisted_24 = { class: "table-cell product-cell" };
const _hoisted_25 = { class: "product-info" };
const _hoisted_26 = { class: "product-image-container" };
const _hoisted_27 = ["src"];
const _hoisted_28 = {
  key: 0,
  class: "check-icon",
  viewBox: "0 0 24 24",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_29 = {
  key: 1,
  class: "pending-icon",
  viewBox: "0 0 24 24",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_30 = { class: "product-details" };
const _hoisted_31 = ["title"];
const _hoisted_32 = { class: "product-ids" };
const _hoisted_33 = { class: "product-id" };
const _hoisted_34 = { class: "plan-id" };
const _hoisted_35 = { class: "table-cell quota-actual-cell" };
const _hoisted_36 = { class: "quota-actual-value" };
const _hoisted_37 = { class: "table-cell quota-suggest-cell" };
const _hoisted_38 = ["title"];
const _hoisted_39 = {
  key: 1,
  class: "quota-comparison"
};
const _hoisted_40 = ["title"];
const _hoisted_41 = ["title"];
const _hoisted_42 = { class: "table-cell price-actual-cell" };
const _hoisted_43 = { class: "price-actual-value" };
const _hoisted_44 = { class: "table-cell price-suggest-cell" };
const _hoisted_45 = ["title"];
const _hoisted_46 = {
  key: 1,
  class: "price-comparison"
};
const _hoisted_47 = ["title"];
const _hoisted_48 = ["title"];
const _hoisted_49 = {
  key: 1,
  style: { height: "0px" },
  class: "virtual-placeholder"
};
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  __name: "PlanTable",
  props: {
    items: {},
    userToken: {},
    itemHeight: { default: 80 },
    containerHeight: { default: 400 },
    showHeader: { type: Boolean, default: true },
    showItemCount: { type: Boolean, default: true },
    showSyncStatus: { type: Boolean, default: true },
    columnWidths: { default: () => ({
      checkbox: "50px",
      product: "300px",
      quotaActual: "120px",
      quotaSuggest: "120px",
      priceActual: "120px",
      priceSuggest: "120px"
    }) },
    onItemSelect: {},
    onItemDeselect: {},
    onSelectAll: {},
    onDeselectAll: {}
  },
  emits: ["resync-completed"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const tableContainer = ref();
    const scrollTop = ref(0);
    const planListData = ref([]);
    const isLoading = ref(false);
    const loadError = ref("");
    const isInitialLoading = ref(true);
    const isWxtSubmitting = ref(false);
    const selectedItems = ref(/* @__PURE__ */ new Set());
    const searchQuery = ref("");
    const allItems = computed(() => {
      if (planListData.value.length > 0) {
        return planListData.value.map((plan) => ({
          id: plan.id,
          // 用于选中功能的唯一标识
          goodsId: plan.goodsId,
          // 商品ID
          name: plan.goodsName,
          // 商品名称
          image: plan.goodsImgUrl,
          // 商品图片
          planId: plan.planId,
          // 计划ID
          // 使用新的数据结构中的字段
          basePrice: plan.basePrice,
          // 基础出价
          realPrice: plan.realPrice,
          // 实际出价
          baseQuota: plan.baseQuota,
          // 基础限额
          realQuota: plan.realQuota,
          // 实际限额
          calcPrice: plan.calcPrice,
          // 计算出价
          customerPrice: plan.customerPrice,
          // 客户出价
          calcQuota: plan.calcQuota,
          // 计算限额
          customerQuota: plan.customerQuota,
          // 客户限额
          isEffect: plan.isEffect || "0"
        }));
      }
      return props.items;
    });
    const totalItems = computed(() => allItems.value.length);
    const filteredItems = computed(() => {
      if (!searchQuery.value.trim()) {
        return allItems.value;
      }
      const query = searchQuery.value.toLowerCase().trim();
      return allItems.value.filter((item) => {
        const itemData = item;
        const nameMatch = itemData.name && itemData.name.toLowerCase().includes(query);
        const goodsIdMatch = itemData.goodsId && itemData.goodsId.toString().includes(query);
        const planIdMatch = itemData.planId && itemData.planId.toString().includes(query);
        return nameMatch || goodsIdMatch || planIdMatch;
      });
    });
    const isAllSelected = computed(() => {
      const selectableItems = filteredItems.value.filter((item) => item.isEffect !== "1");
      return selectableItems.length > 0 && selectedItems.value.size === selectableItems.length;
    });
    const handleScroll = (event) => {
      const target = event.target;
      scrollTop.value = target.scrollTop;
    };
    const formatPrice = (price) => {
      if (price === null || price === void 0) {
        return "0.00";
      }
      return price.toLocaleString("zh-CN", {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
      });
    };
    const formatActualQuotaDisplay = (realQuota, baseQuota) => {
      if (realQuota !== null && realQuota !== void 0) {
        return {
          showSuggestOnly: true,
          suggestValue: realQuota.toString(),
          class: "actual-quota-real"
        };
      }
      if (baseQuota !== null && baseQuota !== void 0) {
        return {
          showSuggestOnly: true,
          suggestValue: baseQuota.toString(),
          class: "actual-quota-base"
        };
      }
      return {
        showSuggestOnly: true,
        suggestValue: "-",
        class: "actual-quota-empty"
      };
    };
    const formatActualPriceDisplay = (realPrice, basePrice) => {
      if (realPrice !== null && realPrice !== void 0) {
        return {
          showSuggestOnly: true,
          suggestValue: formatPrice(realPrice),
          class: "actual-price-real"
        };
      }
      if (basePrice !== null && basePrice !== void 0) {
        return {
          showSuggestOnly: true,
          suggestValue: formatPrice(basePrice),
          class: "actual-price-base"
        };
      }
      return {
        showSuggestOnly: true,
        suggestValue: "-",
        class: "actual-price-empty"
      };
    };
    const formatQuotaDisplay = (calcQuota, customerQuota) => {
      const calc = calcQuota;
      const customer = customerQuota;
      if (customerQuota === null || customerQuota === void 0 || customer === calc) {
        return {
          showSuggestOnly: true,
          suggestValue: calc === null || calc === void 0 ? "-" : calc.toString(),
          class: "calc-quota-same"
        };
      } else {
        return {
          showSuggestOnly: false,
          suggestValue: calc === null || calc === void 0 ? "-" : calc.toString(),
          modifyValue: customer === null || customer === void 0 ? "-" : customer.toString(),
          class: "calc-quota-different"
        };
      }
    };
    const formatPriceDisplay = (calcPrice, customerPrice) => {
      const calc = calcPrice;
      const customer = customerPrice;
      if (customerPrice === null || customerPrice === void 0 || customer === calc) {
        return {
          showSuggestOnly: true,
          suggestValue: calc === null || calc === void 0 ? "-" : formatPrice(calc),
          class: "calc-price-same"
        };
      } else {
        return {
          showSuggestOnly: false,
          suggestValue: calc === null || calc === void 0 ? "-" : formatPrice(calc),
          modifyValue: customer === null || customer === void 0 ? "-" : formatPrice(customer),
          class: "calc-price-different"
        };
      }
    };
    const handleImageError = (event) => {
      const img = event.target;
      img.src = "data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3Qgd2lkdGg9IjQwIiBoZWlnaHQ9IjQwIiBmaWxsPSIjRjNGNEY2Ii8+CjxwYXRoIGQ9Ik0yMCAyMEMyMi4yMDkxIDIwIDI0IDE4LjIwOTEgMjQgMTZDMjQgMTMuNzkwOSAyMi4yMDkxIDEyIDIwIDEyQzE3Ljc5MDkgMTIgMTYgMTMuNzkwOSAxNiAxNkMxNiAxOC4yMDkxIDE3Ljc5MDkgMjAgMjAgMjBaIiBmaWxsPSIjOUNBM0FGIi8+CjxwYXRoIGQ9Ik0yMCAyNEMyMi4yMDkxIDI0IDI0IDIyLjIwOTEgMjQgMjBDMjQgMTcuNzkwOSAyMi4yMDkxIDE2IDIwIDE2QzE3Ljc5MDkgMTYgMTYgMTcuNzkwOSAxNiAyMEMxNiAyMi4yMDkxIDE3Ljc5MDkgMjQgMjAgMjRaIiBmaWxsPSIjOUNBM0FGIi8+Cjwvc3ZnPgo=";
    };
    const handleSelectAll = (event) => {
      const target = event.target;
      if (target.checked) {
        const selectableItems = filteredItems.value.filter((item) => item.isEffect !== "1");
        selectableItems.forEach((item) => {
          selectedItems.value.add(item.id);
        });
        if (props.onSelectAll) {
          props.onSelectAll(selectableItems);
        }
      } else {
        selectedItems.value.clear();
        if (props.onDeselectAll) {
          props.onDeselectAll();
        }
      }
    };
    const handleItemSelect = (itemId, event) => {
      const target = event.target;
      const item = allItems.value.find((item2) => item2.id === itemId);
      if (target.checked) {
        selectedItems.value.add(itemId);
        if (item && props.onItemSelect) {
          props.onItemSelect(item);
        }
      } else {
        selectedItems.value.delete(itemId);
        if (item && props.onItemDeselect) {
          props.onItemDeselect(item);
        }
      }
    };
    const handleSearchInput = () => {
      selectedItems.value.clear();
    };
    const clearSearch = () => {
      searchQuery.value = "";
      selectedItems.value.clear();
    };
    const handleRefresh = () => {
      console.log("[PLANTABLE] 刷新数据");
      selectedItems.value.clear();
      loadPlanListData();
    };
    const confirmResync = () => __async(this, null, function* () {
      var _a, _b;
      try {
        console.log("[PLANTABLE] 开始重新同步");
        const response = yield resetSyncAPI(props.userToken);
        if (response.code !== "0") {
          console.error("[PLANTABLE] 重新同步API返回错误:", response);
          UnifiedDialogManager.showError(response.msg || "重新同步失败，请重试", {
            title: "重新同步失败",
            confirmText: "确定",
            showCancel: false
          });
          return;
        }
        console.log("[PLANTABLE] 重新同步完成");
        emit("resync-completed");
        selectedItems.value.clear();
        yield loadPlanListData();
      } catch (error) {
        console.error("[PLANTABLE] 重新同步失败:", error);
        logError(error, "重新同步失败");
        let errorMessage = "重新同步失败，请重试";
        if ((_b = (_a = error == null ? void 0 : error.response) == null ? void 0 : _a.data) == null ? void 0 : _b.msg) {
          errorMessage = error.response.data.msg;
        } else if (error == null ? void 0 : error.message) {
          errorMessage = error.message;
        }
        UnifiedDialogManager.showError(errorMessage, {
          title: "重新同步失败",
          confirmText: "确定",
          showCancel: false
        });
      }
    });
    const handleResync = () => {
      console.log("🔄 [PLANTABLE] 显示重新同步确认弹窗");
      UnifiedDialogManager.showWarning(
        "确定要重新同步数据吗？这将清除当前数据并重新开始同步过程。",
        {
          title: "确认重新同步",
          confirmText: "确定",
          cancelText: "取消",
          showCancel: true,
          onConfirm: () => __async(this, null, function* () {
            yield confirmResync();
          })
        }
      );
    };
    const handleDetailedList = () => {
      console.log("[PLANTABLE] 打开详细列表");
      chrome.runtime.sendMessage({
        action: "manageFulllistWindow"
      }, (response) => {
        if (chrome.runtime.lastError) {
          console.error("📱 [PLANTABLE] 管理fulllist窗口失败:", chrome.runtime.lastError);
          return;
        }
        if (response && response.success) {
          if (response.action === "focused_existing") {
            console.log("📱 [PLANTABLE] 切换到现有fulllist窗口:", response.windowId);
            setTimeout(() => {
              console.log("📱 [PLANTABLE] 关闭当前popup窗口");
              window.close();
            }, 100);
          } else if (response.action === "create_new") {
            console.log("📱 [PLANTABLE] 创建新的fulllist窗口");
            const planFullListUrl = chrome.runtime.getURL("planfulllist/index.html");
            const urlWithCloseFlag = `${planFullListUrl}?closeParentPopup=true`;
            chrome.runtime.sendMessage({
              action: "createFulllistWindow",
              url: urlWithCloseFlag
            }, (createResponse) => {
              if (chrome.runtime.lastError) {
                console.error("📱 [PLANTABLE] 创建fulllist窗口失败:", chrome.runtime.lastError);
              } else if (createResponse && createResponse.success) {
                console.log("📱 [PLANTABLE] ✅ 已创建新的fulllist窗口:", createResponse.windowId);
                setTimeout(() => {
                  console.log("📱 [PLANTABLE] 关闭当前popup窗口");
                  window.close();
                }, 100);
              }
            });
          }
        } else {
          console.error("📱 [PLANTABLE] 管理fulllist窗口失败:", response == null ? void 0 : response.error);
        }
      });
    };
    const confirmWxtSubmit = (selectedProducts) => __async(this, null, function* () {
      console.log("[PLANTABLE] 执行万向台提交，选中的商品:", selectedProducts);
      isWxtSubmitting.value = true;
      try {
        UnifiedDialogManager.showInfo("正在执行万相台提交，请稍候...", {
          title: "万相台提交中",
          showCancel: false
        });
        const results = [];
        for (const product of selectedProducts) {
          try {
            console.log("[PLANTABLE] 处理商品:", product);
            const price = product.customerPrice || product.calcPrice;
            const quota = product.customerQuota || product.calcQuota;
            console.log("[PLANTABLE] 商品信息 - ID:", product.id, "goodsId:", product.goodsId, "price:", price, "quota:", quota);
            const result2 = yield executeWxtSubmit(product.id, product.goodsId, price, quota);
            results.push({ product, result: result2 });
            console.log("[PLANTABLE] 商品提交结果:", result2);
          } catch (error) {
            console.error("[PLANTABLE] 商品提交失败:", product, error);
            results.push({ product, result: { success: false, error: error instanceof Error ? error.message : "未知错误" } });
          }
        }
        const successCount = results.filter((r) => r.result.success).length;
        const totalCount = results.length;
        console.log(`[PLANTABLE] 万相台提交完成 - 成功: ${successCount}/${totalCount}`);
        let result;
        if (successCount === totalCount) {
          result = { success: true, message: `所有商品提交成功 (${successCount}/${totalCount})` };
        } else if (successCount > 0) {
          result = { success: false, message: `部分商品提交成功 (${successCount}/${totalCount})` };
        } else {
          result = { success: false, message: `所有商品提交失败 (${successCount}/${totalCount})` };
        }
        selectedItems.value.clear();
        yield loadPlanListData();
        if (result.success) {
          console.log("✅ [PLANTABLE] 万相台提交成功:", result.message);
          UnifiedDialogManager.showSuccess(result.message, {
            title: "提交成功",
            confirmText: "确定"
          });
        } else {
          console.error("❌ [PLANTABLE] 万相台提交失败:", result.error || "未知错误");
          UnifiedDialogManager.showError(result.message, {
            title: "提交失败",
            confirmText: "确定"
          });
        }
      } catch (error) {
        console.error("❌ [PLANTABLE] 万相台提交异常:", error);
        logError(error, "万相台提交", {
          additionalInfo: "PlanTable组件中调用万相台提交功能时发生异常"
        });
        UnifiedDialogManager.showError("万相台提交过程中发生异常，请重试", {
          title: "提交异常",
          confirmText: "确定"
        });
      } finally {
        isWxtSubmitting.value = false;
      }
    });
    const handleWxtSubmit = () => {
      if (isWxtSubmitting.value) {
        console.log("⚠️ [PLANTABLE] 万相台提交正在进行中，忽略重复操作");
        return;
      }
      if (selectedItems.value.size === 0) {
        console.log("⚠️ [PLANTABLE] 没有选中的商品，弹窗报错");
        UnifiedDialogManager.showError("请先选择要提交的商品", {
          title: "没有选中的商品",
          confirmText: "确定"
        });
        return;
      }
      console.log("📤 [PLANTABLE] 显示万向台提交确认弹窗");
      UnifiedDialogManager.showWarning(
        '您将要修改万相台全站推计划的预算和出价，请确定<span class="text-danger"> 多目标优化 </span>和<span class="text-danger"> 一键起量 </span>设置<span class="text-danger"> 已关闭！</span>',
        {
          title: "确认提交万向台",
          confirmText: "确定",
          cancelText: "取消",
          showCancel: true,
          onConfirm: () => {
            const selectedProducts = allItems.value.filter((item) => selectedItems.value.has(item.id));
            confirmWxtSubmit(selectedProducts);
          }
        }
      );
    };
    const loadPlanListData = () => __async(this, null, function* () {
      try {
        isLoading.value = true;
        loadError.value = "";
        console.log("开始加载计划列表数据...", {
          token: props.userToken.substring(0, 10) + "..."
        });
        const response = yield getPlanListAPI(props.userToken);
        if (response.code === "0" && response.data) {
          planListData.value = response.data;
          console.log("✅ 计划列表数据加载成功:", {
            total: response.total || response.data.length,
            plansCount: planListData.value.length
          });
          if (planListData.value.length > 0) {
            const firstItem = planListData.value[0];
            if (firstItem) {
              console.log("🔍 第一条完整数据:", firstItem);
              console.log("🔍 数据字段检查:", {
                hasBaseQuota: "baseQuota" in firstItem,
                hasRealQuota: "realQuota" in firstItem,
                hasBasePrice: "basePrice" in firstItem,
                hasRealPrice: "realPrice" in firstItem,
                hasCalcQuota: "calcQuota" in firstItem,
                hasCustomerQuota: "customerQuota" in firstItem,
                hasCalcPrice: "calcPrice" in firstItem,
                hasCustomerPrice: "customerPrice" in firstItem,
                hasIsEffect: "isEffect" in firstItem
              });
            }
          }
        } else {
          throw new Error(response.msg || "获取计划列表失败");
        }
      } catch (error) {
        console.error("加载计划列表数据失败:", error);
        loadError.value = error.message || "加载数据失败";
        logError(error, "加载计划列表数据失败", {
          additionalInfo: `用户token: ${props.userToken.substring(0, 10)}...`
        });
      } finally {
        isLoading.value = false;
        isInitialLoading.value = false;
      }
    });
    onMounted(() => {
      loadPlanListData();
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$6, [
        createBaseVNode("div", _hoisted_2$5, [
          createBaseVNode("div", _hoisted_3$5, [
            _cache[2] || (_cache[2] = createBaseVNode("span", { class: "title-text" }, "计划列表", -1)),
            createBaseVNode("span", _hoisted_4$3, "(共" + toDisplayString(totalItems.value) + "件商品)", 1),
            searchQuery.value ? (openBlock(), createElementBlock("span", _hoisted_5$3, "(筛选后" + toDisplayString(filteredItems.value.length) + "件)", 1)) : createCommentVNode("", true)
          ]),
          createBaseVNode("div", _hoisted_6$3, [
            createBaseVNode("button", {
              onClick: handleRefresh,
              class: "action-button refresh-button"
            }, "刷新"),
            createBaseVNode("button", {
              onClick: handleResync,
              class: "action-button resync-button"
            }, "重新同步"),
            createBaseVNode("button", {
              onClick: handleDetailedList,
              class: "action-button maximize-button"
            }, "最大化"),
            createBaseVNode("button", {
              onClick: handleWxtSubmit,
              class: normalizeClass(["action-button wxt-submit-button", { "button-disabled": isWxtSubmitting.value }]),
              disabled: isWxtSubmitting.value
            }, toDisplayString(isWxtSubmitting.value ? "提交中..." : "提交万相台"), 11, _hoisted_7$3)
          ])
        ]),
        isLoading.value || isInitialLoading.value ? (openBlock(), createElementBlock("div", _hoisted_8$2, [..._cache[3] || (_cache[3] = [
          createBaseVNode("div", { class: "loading-spinner" }, null, -1),
          createBaseVNode("div", { class: "loading-text" }, "加载中...", -1)
        ])])) : createCommentVNode("", true),
        isWxtSubmitting.value ? (openBlock(), createElementBlock("div", _hoisted_9$2, [..._cache[4] || (_cache[4] = [
          createBaseVNode("div", { class: "wxt-submit-loading-content" }, [
            createBaseVNode("div", { class: "wxt-submit-spinner" }),
            createBaseVNode("div", { class: "wxt-submit-text" }, "万相台提交中..."),
            createBaseVNode("div", { class: "wxt-submit-subtitle" }, "请勿关闭页面或进行其他操作")
          ], -1)
        ])])) : loadError.value ? (openBlock(), createElementBlock("div", _hoisted_10$2, [
          createBaseVNode("div", _hoisted_11$2, toDisplayString(loadError.value), 1),
          createBaseVNode("button", {
            class: "retry-button",
            onClick: _cache[0] || (_cache[0] = () => loadPlanListData())
          }, "重试")
        ])) : (openBlock(), createElementBlock("div", _hoisted_12$1, [
          createBaseVNode("div", _hoisted_13$1, [
            createBaseVNode("div", _hoisted_14$1, [
              createBaseVNode("input", {
                type: "checkbox",
                checked: isAllSelected.value,
                onChange: handleSelectAll,
                class: "select-all-checkbox"
              }, null, 40, _hoisted_15)
            ]),
            createBaseVNode("div", _hoisted_16, [
              createBaseVNode("div", _hoisted_17, [
                createBaseVNode("div", _hoisted_18, [
                  _cache[6] || (_cache[6] = createBaseVNode("span", { class: "product-header-title" }, "商品", -1)),
                  createBaseVNode("div", _hoisted_19, [
                    withDirectives(createBaseVNode("input", {
                      type: "text",
                      "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => searchQuery.value = $event),
                      placeholder: "搜索商品名称、ID、计划ID",
                      class: "search-input",
                      onInput: handleSearchInput
                    }, null, 544), [
                      [vModelText, searchQuery.value]
                    ]),
                    searchQuery.value ? (openBlock(), createElementBlock("div", {
                      key: 0,
                      class: "search-clear",
                      onClick: clearSearch
                    }, [..._cache[5] || (_cache[5] = [
                      createBaseVNode("svg", {
                        class: "clear-icon",
                        viewBox: "0 0 24 24",
                        fill: "none",
                        xmlns: "http://www.w3.org/2000/svg"
                      }, [
                        createBaseVNode("circle", {
                          cx: "12",
                          cy: "12",
                          r: "10",
                          fill: "#6b7280"
                        }),
                        createBaseVNode("path", {
                          d: "M15 9l-6 6M9 9l6 6",
                          stroke: "white",
                          "stroke-width": "2",
                          "stroke-linecap": "round",
                          "stroke-linejoin": "round"
                        })
                      ], -1)
                    ])])) : createCommentVNode("", true)
                  ])
                ])
              ])
            ]),
            _cache[7] || (_cache[7] = createBaseVNode("div", { class: "header-cell quota-actual-cell" }, "实际限额", -1)),
            _cache[8] || (_cache[8] = createBaseVNode("div", { class: "header-cell quota-suggest-cell" }, "建议限额", -1)),
            _cache[9] || (_cache[9] = createBaseVNode("div", { class: "header-cell price-actual-cell" }, "实际出价", -1)),
            _cache[10] || (_cache[10] = createBaseVNode("div", { class: "header-cell price-suggest-cell" }, "建议出价", -1))
          ]),
          createBaseVNode("div", {
            ref_key: "tableContainer",
            ref: tableContainer,
            class: "virtual-container",
            style: normalizeStyle({ height: props.containerHeight + "px" }),
            onScroll: handleScroll
          }, [
            allItems.value.length > 0 ? (openBlock(), createElementBlock("div", _hoisted_20)) : createCommentVNode("", true),
            createBaseVNode("div", _hoisted_21, [
              (openBlock(true), createElementBlock(Fragment, null, renderList(filteredItems.value, (item, index) => {
                return openBlock(), createElementBlock("div", {
                  key: item.id,
                  class: normalizeClass(["table-row", {
                    "row-even": index % 2 === 0,
                    "row-selected": selectedItems.value.has(item.id),
                    "row-synced": item.isEffect === "1"
                  }])
                }, [
                  createBaseVNode("div", _hoisted_22, [
                    createBaseVNode("input", {
                      type: "checkbox",
                      checked: selectedItems.value.has(item.id),
                      onChange: ($event) => handleItemSelect(item.id, $event),
                      disabled: item.isEffect === "1",
                      class: normalizeClass(["item-checkbox", { "checkbox-disabled": item.isEffect === "1" }])
                    }, null, 42, _hoisted_23)
                  ]),
                  createBaseVNode("div", _hoisted_24, [
                    createBaseVNode("div", _hoisted_25, [
                      createBaseVNode("div", _hoisted_26, [
                        createBaseVNode("img", {
                          src: item.image,
                          class: "product-image",
                          onError: handleImageError
                        }, null, 40, _hoisted_27),
                        createBaseVNode("div", {
                          class: normalizeClass(["sync-status-icon", { "sync-success": item.isEffect === "1", "sync-pending": item.isEffect === "0" }])
                        }, [
                          item.isEffect === "1" ? (openBlock(), createElementBlock("svg", _hoisted_28, [..._cache[11] || (_cache[11] = [
                            createBaseVNode("circle", {
                              cx: "12",
                              cy: "12",
                              r: "10",
                              fill: "#10B981"
                            }, null, -1),
                            createBaseVNode("path", {
                              d: "M9 12l2 2 4-4",
                              stroke: "white",
                              "stroke-width": "2",
                              "stroke-linecap": "round",
                              "stroke-linejoin": "round"
                            }, null, -1)
                          ])])) : (openBlock(), createElementBlock("svg", _hoisted_29, [..._cache[12] || (_cache[12] = [
                            createBaseVNode("circle", {
                              cx: "12",
                              cy: "12",
                              r: "10",
                              fill: "#F59E0B"
                            }, null, -1),
                            createBaseVNode("path", {
                              d: "M12 6v6l4 2",
                              stroke: "white",
                              "stroke-width": "2",
                              "stroke-linecap": "round",
                              "stroke-linejoin": "round"
                            }, null, -1)
                          ])]))
                        ], 2)
                      ]),
                      createBaseVNode("div", _hoisted_30, [
                        createBaseVNode("div", {
                          class: "product-name",
                          title: item.name
                        }, toDisplayString(item.name), 9, _hoisted_31),
                        createBaseVNode("div", _hoisted_32, [
                          createBaseVNode("span", _hoisted_33, "商品ID: " + toDisplayString(item.goodsId), 1),
                          createBaseVNode("span", _hoisted_34, "计划ID: " + toDisplayString(item.planId), 1)
                        ])
                      ])
                    ])
                  ]),
                  createBaseVNode("div", _hoisted_35, [
                    createBaseVNode("div", _hoisted_36, toDisplayString(formatActualQuotaDisplay(item.realQuota, item.baseQuota).suggestValue), 1)
                  ]),
                  createBaseVNode("div", _hoisted_37, [
                    formatQuotaDisplay(item.calcQuota, item.customerQuota).showSuggestOnly ? (openBlock(), createElementBlock("div", {
                      key: 0,
                      class: normalizeClass(["quota-suggest-value", { "quota-dash": item.calcQuota === null || item.calcQuota === void 0 }]),
                      title: `建议：${item.calcQuota === null ? "-" : item.calcQuota}`
                    }, toDisplayString(formatQuotaDisplay(item.calcQuota, item.customerQuota).suggestValue), 11, _hoisted_38)) : (openBlock(), createElementBlock("div", _hoisted_39, [
                      createBaseVNode("div", {
                        class: "quota-suggest-value strikethrough",
                        title: `建议：${item.calcQuota === null ? "-" : item.calcQuota}`
                      }, toDisplayString(formatQuotaDisplay(item.calcQuota, item.customerQuota).suggestValue), 9, _hoisted_40),
                      createBaseVNode("div", {
                        class: "quota-modify-value",
                        title: `修改：${item.customerQuota === null ? "-" : item.customerQuota}`
                      }, toDisplayString(formatQuotaDisplay(item.calcQuota, item.customerQuota).modifyValue), 9, _hoisted_41)
                    ]))
                  ]),
                  createBaseVNode("div", _hoisted_42, [
                    createBaseVNode("div", _hoisted_43, toDisplayString(formatActualPriceDisplay(item.realPrice, item.basePrice).suggestValue), 1)
                  ]),
                  createBaseVNode("div", _hoisted_44, [
                    formatPriceDisplay(item.calcPrice, item.customerPrice).showSuggestOnly ? (openBlock(), createElementBlock("div", {
                      key: 0,
                      class: "price-suggest-value",
                      title: `建议：${item.calcPrice === null ? "-" : formatPrice(item.calcPrice)}`
                    }, toDisplayString(formatPriceDisplay(item.calcPrice, item.customerPrice).suggestValue), 9, _hoisted_45)) : (openBlock(), createElementBlock("div", _hoisted_46, [
                      createBaseVNode("div", {
                        class: "price-suggest-value strikethrough",
                        title: `建议：${item.calcPrice === null ? "-" : formatPrice(item.calcPrice)}`
                      }, toDisplayString(formatPriceDisplay(item.calcPrice, item.customerPrice).suggestValue), 9, _hoisted_47),
                      createBaseVNode("div", {
                        class: "price-modify-value",
                        title: `修改：${item.customerPrice === null ? "-" : formatPrice(item.customerPrice)}`
                      }, toDisplayString(formatPriceDisplay(item.calcPrice, item.customerPrice).modifyValue), 9, _hoisted_48)
                    ]))
                  ])
                ], 2);
              }), 128))
            ]),
            filteredItems.value.length > 0 ? (openBlock(), createElementBlock("div", _hoisted_49)) : createCommentVNode("", true)
          ], 36)
        ]))
      ]);
    };
  }
});
const PlanTable = /* @__PURE__ */ _export_sfc(_sfc_main$6, [["__scopeId", "data-v-92ccf25e"]]);
const _hoisted_1$5 = { class: "hint-tooltip-content" };
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "HintTooltip",
  props: {
    visible: { type: Boolean },
    text: { default: "点击这里" },
    color: { default: "#10b981" },
    animated: { type: Boolean, default: true },
    position: { default: () => ({}) }
  },
  setup(__props) {
    const props = __props;
    const hintStyle = computed(() => {
      const defaultPosition = {
        top: "-50px",
        left: "50%",
        transform: "translateX(-50%)"
      };
      const style = __spreadValues(__spreadValues({}, defaultPosition), props.position);
      if (props.position.top !== void 0 || props.position.bottom !== void 0) {
        style.transform = "translateX(-50%)";
      }
      if (props.position.left !== void 0 && props.position.right === void 0) {
        style.transform = "none";
      }
      return style;
    });
    return (_ctx, _cache) => {
      return _ctx.visible ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: "hint-tooltip",
        style: normalizeStyle(__spreadProps(__spreadValues({}, hintStyle.value), { "--hint-color": _ctx.color }))
      }, [
        createBaseVNode("div", _hoisted_1$5, [
          createBaseVNode("div", {
            class: normalizeClass(["hint-text", { "pulsing": _ctx.animated }])
          }, toDisplayString(_ctx.text), 3),
          createBaseVNode("div", {
            class: normalizeClass(["hint-arrow", { "bouncing": _ctx.animated }])
          }, null, 2)
        ])
      ], 4)) : createCommentVNode("", true);
    };
  }
});
const HintTooltip = /* @__PURE__ */ _export_sfc(_sfc_main$5, [["__scopeId", "data-v-6ffc4294"]]);
const _hoisted_1$4 = { class: "task-main-row" };
const _hoisted_2$4 = { class: "task-content" };
const _hoisted_3$4 = {
  key: 0,
  class: "icon-content"
};
const _hoisted_4$2 = {
  key: 1,
  class: "icon-content"
};
const _hoisted_5$2 = {
  key: 2,
  class: "icon-content"
};
const _hoisted_6$2 = {
  key: 3,
  class: "icon-content"
};
const _hoisted_7$2 = { class: "task-info" };
const _hoisted_8$1 = { class: "task-left" };
const _hoisted_9$1 = { class: "task-title" };
const _hoisted_10$1 = { class: "title-text" };
const _hoisted_11$1 = { class: "task-desc" };
const _hoisted_12 = { class: "task-right" };
const _hoisted_13 = { class: "progress-stages" };
const _hoisted_14 = ["accept"];
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "SyncTaskItem",
  props: {
    title: {},
    description: {},
    taskStatus: {},
    allowedFileTypes: {},
    disabled: { type: Boolean },
    orangeStyle: { type: Boolean },
    taskType: {},
    syncButtonClickable: { type: Boolean }
  },
  emits: ["task-click", "file-selected"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const fileInput = ref(null);
    const selectedFile = ref(null);
    const isFileSelected = ref(false);
    const internalStageStatus = ref(null);
    const stageStatus = computed(() => {
      if (internalStageStatus.value !== null) {
        return internalStageStatus.value;
      }
      switch (props.taskStatus) {
        case TaskStatus.PENDING:
          return void 0;
        case TaskStatus.SYNCING:
          return StageStatus.ANALYZING;
        case TaskStatus.COMPLETED:
          return StageStatus.ANALYZE_COMPLETED;
        default:
          return void 0;
      }
    });
    const statusInfo = computed(() => getTaskStatusInfo(props.taskStatus, stageStatus.value));
    const fileInputAccept = computed(() => {
      if (!props.allowedFileTypes || props.allowedFileTypes.length === 0) {
        return "";
      }
      return props.allowedFileTypes.map((type) => `.${type}`).join(",");
    });
    const syncStageCursor = computed(() => {
      if (props.disabled) {
        return "not-allowed";
      }
      if (props.syncButtonClickable === false) {
        return "not-allowed";
      }
      if (stageStatus.value === StageStatus.COLLECT_COMPLETED) {
        return "pointer";
      }
      if (props.taskStatus === TaskStatus.PENDING && !stageStatus.value) {
        return "pointer";
      }
      return "not-allowed";
    });
    watch(() => props.taskStatus, (newTaskStatus) => {
      if (internalStageStatus.value !== null) {
        if (newTaskStatus === TaskStatus.PENDING) {
          internalStageStatus.value = null;
        } else if (newTaskStatus === TaskStatus.SYNCING) {
          internalStageStatus.value = null;
        } else if (newTaskStatus === TaskStatus.COMPLETED) {
          internalStageStatus.value = null;
        }
      }
      if (newTaskStatus === TaskStatus.PENDING) {
        resetFileSelection();
      }
    });
    const handleTaskClick = (event) => __async(this, null, function* () {
      try {
        if (props.disabled) {
          return;
        }
        if (props.taskStatus === TaskStatus.COMPLETED) {
          return;
        }
        if (stageStatus.value === StageStatus.COLLECT_COMPLETED) {
          return;
        }
        if (statusInfo.value.isProcessing) {
          return;
        }
        internalStageStatus.value = StageStatus.COLLECTING;
        yield emit("task-click", event);
      } catch (error) {
        console.error("任务执行失败:", error);
        internalStageStatus.value = StageStatus.COLLECT_ERROR;
      }
    });
    const handleSyncStageClick = (event) => {
      var _a;
      event.stopPropagation();
      if (props.disabled) {
        return;
      }
      if (props.syncButtonClickable === false) {
        return;
      }
      if (stageStatus.value === StageStatus.COLLECT_COMPLETED) {
        (_a = fileInput.value) == null ? void 0 : _a.click();
        return;
      }
      if (props.taskStatus === TaskStatus.PENDING && !stageStatus.value) {
        internalStageStatus.value = StageStatus.COLLECTING;
        emit("task-click", event);
        return;
      }
    };
    const handleFileSelect = (event) => {
      var _a, _b;
      const target = event.target;
      const file = (_a = target.files) == null ? void 0 : _a[0];
      if (file) {
        if (!props.allowedFileTypes || props.allowedFileTypes.length === 0) {
          alert("未配置允许的文件类型");
          return;
        }
        const allowedTypes = props.allowedFileTypes.map((type) => `.${type.toLowerCase()}`);
        const fileExtension = "." + ((_b = file.name.split(".").pop()) == null ? void 0 : _b.toLowerCase());
        if (!allowedTypes.includes(fileExtension)) {
          const allowedTypesText = allowedTypes.join(", ");
          __vitePreload(() => __async(this, null, function* () {
            const { UnifiedDialogManager: UnifiedDialogManager2 } = yield Promise.resolve().then(() => unifiedDialogManager);
            return { UnifiedDialogManager: UnifiedDialogManager2 };
          }), true ? void 0 : void 0, import.meta.url).then(({ UnifiedDialogManager: UnifiedDialogManager2 }) => {
            UnifiedDialogManager2.showError(`请选择支持的文件类型: ${allowedTypesText}`);
          });
          return;
        }
        const maxSize = 10 * 1024 * 1024;
        if (file.size > maxSize) {
          __vitePreload(() => __async(this, null, function* () {
            const { UnifiedDialogManager: UnifiedDialogManager2 } = yield Promise.resolve().then(() => unifiedDialogManager);
            return { UnifiedDialogManager: UnifiedDialogManager2 };
          }), true ? void 0 : void 0, import.meta.url).then(({ UnifiedDialogManager: UnifiedDialogManager2 }) => {
            UnifiedDialogManager2.showError("文件大小不能超过10MB");
          });
          return;
        }
        selectedFile.value = file;
        isFileSelected.value = true;
        internalStageStatus.value = StageStatus.SYNCING_DETAIL;
        emit("file-selected", file);
      }
    };
    const getStageClass$1 = (stage) => {
      return getStageClass(props.taskStatus, stage, stageStatus.value);
    };
    const setTaskCollecting = () => {
      internalStageStatus.value = StageStatus.COLLECTING;
    };
    const setTaskCompleted = () => {
      internalStageStatus.value = StageStatus.COLLECT_COMPLETED;
    };
    const setTaskError = () => {
      internalStageStatus.value = StageStatus.COLLECT_ERROR;
    };
    const setSyncFailure = () => {
    };
    const resetFileSelection = () => {
      selectedFile.value = null;
      isFileSelected.value = false;
      if (fileInput.value) {
        fileInput.value.value = "";
      }
      if (internalStageStatus.value === StageStatus.SYNCING_DETAIL) {
        internalStageStatus.value = null;
      }
    };
    const clearInternalStatus = () => {
      internalStageStatus.value = null;
    };
    __expose({
      setTaskCollecting,
      setTaskCompleted,
      setTaskError,
      setSyncFailure,
      clearInternalStatus,
      resetFileSelection
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["sync-task", {
          "completed": statusInfo.value.isCompleted,
          "current": false,
          "processing": statusInfo.value.isProcessing,
          "error": statusInfo.value.isError,
          "disabled": props.disabled || statusInfo.value.isProcessing,
          "orange-style": props.orangeStyle && !statusInfo.value.isProcessing && !statusInfo.value.isCompleted && !statusInfo.value.isError
        }]),
        onClick: handleTaskClick
      }, [
        createBaseVNode("div", _hoisted_1$4, [
          createBaseVNode("div", _hoisted_2$4, [
            createBaseVNode("div", {
              class: normalizeClass(["task-icon", `icon-${statusInfo.value.iconType}`])
            }, [
              statusInfo.value.iconType === "completed" ? (openBlock(), createElementBlock("div", _hoisted_3$4, "✓")) : statusInfo.value.iconType === "error" ? (openBlock(), createElementBlock("div", _hoisted_4$2, "!")) : statusInfo.value.iconType === "loading" ? (openBlock(), createElementBlock("div", _hoisted_5$2, [..._cache[0] || (_cache[0] = [
                createBaseVNode("div", { class: "loading-spinner-small" }, null, -1)
              ])])) : (openBlock(), createElementBlock("div", _hoisted_6$2, "○"))
            ], 2),
            createBaseVNode("div", _hoisted_7$2, [
              createBaseVNode("div", _hoisted_8$1, [
                createBaseVNode("div", _hoisted_9$1, [
                  createBaseVNode("span", _hoisted_10$1, toDisplayString(_ctx.title), 1)
                ]),
                createBaseVNode("div", _hoisted_11$1, toDisplayString(_ctx.description), 1)
              ]),
              createBaseVNode("div", _hoisted_12, [
                createBaseVNode("div", _hoisted_13, [
                  createBaseVNode("div", {
                    class: normalizeClass(["stage", [getStageClass$1("收集"), { "blinking": stageStatus.value === unref(StageStatus).COLLECTING && statusInfo.value.isProcessing }]])
                  }, "收集", 2),
                  _cache[2] || (_cache[2] = createBaseVNode("div", { class: "stage-separator" }, null, -1)),
                  createBaseVNode("div", {
                    class: normalizeClass(["stage sync-stage", [getStageClass$1("同步"), { "blinking": stageStatus.value === unref(StageStatus).SYNCING_DETAIL && statusInfo.value.isProcessing }]]),
                    onClick: handleSyncStageClick,
                    style: normalizeStyle({ cursor: syncStageCursor.value })
                  }, [
                    _cache[1] || (_cache[1] = createTextVNode(" 同步 ", -1)),
                    createVNode(HintTooltip, {
                      visible: stageStatus.value === unref(StageStatus).COLLECT_COMPLETED,
                      text: "点击这里上传",
                      color: "#10b981",
                      animated: true
                    }, null, 8, ["visible"])
                  ], 6),
                  _cache[3] || (_cache[3] = createBaseVNode("div", { class: "stage-separator" }, null, -1)),
                  createBaseVNode("div", {
                    class: normalizeClass(["stage", [getStageClass$1("分析"), { "blinking": (stageStatus.value === unref(StageStatus).ANALYZING || stageStatus.value === unref(StageStatus).ANALYZE_COMPLETED) && statusInfo.value.isProcessing }]])
                  }, "分析", 2)
                ])
              ])
            ])
          ])
        ]),
        createBaseVNode("input", {
          ref_key: "fileInput",
          ref: fileInput,
          type: "file",
          accept: fileInputAccept.value,
          onChange: handleFileSelect,
          style: { "display": "none" }
        }, null, 40, _hoisted_14)
      ], 2);
    };
  }
});
const SyncTaskItem = /* @__PURE__ */ _export_sfc(_sfc_main$4, [["__scopeId", "data-v-0bb6906e"]]);
class BackgroundStateClient {
  /**
   * 从background获取当前同步状态
   */
  static getCurrentSyncStatus() {
    return __async(this, null, function* () {
      return new Promise((resolve) => {
        chrome.runtime.sendMessage(
          { action: "getCurrentSyncStatus" },
          (response) => {
            if (chrome.runtime.lastError) {
              console.error("获取同步状态失败:", chrome.runtime.lastError);
              resolve(null);
            } else if ((response == null ? void 0 : response.success) && response.data) {
              resolve(response.data);
            } else {
              console.error("获取同步状态失败:", response == null ? void 0 : response.error);
              resolve(null);
            }
          }
        );
      });
    });
  }
  /**
   * 直接调用接口获取状态（一次性）
   * @param token 用户token
   * @returns 同步状态数据
   */
  static fetchSyncStatusOnce(token) {
    return __async(this, null, function* () {
      return new Promise((resolve) => {
        chrome.runtime.sendMessage(
          { action: "fetchSyncStatusOnce", token },
          (response) => {
            if (chrome.runtime.lastError) {
              console.error("直接调用接口失败:", chrome.runtime.lastError);
              resolve(null);
            } else if ((response == null ? void 0 : response.success) && response.data) {
              resolve(response.data);
            } else {
              console.error("直接调用接口失败:", response == null ? void 0 : response.error);
              resolve(null);
            }
          }
        );
      });
    });
  }
  /**
   * 启动同步状态轮询
   * @param token 用户token
   */
  static startSyncStatusPolling(token) {
    return __async(this, null, function* () {
      return new Promise((resolve) => {
        chrome.runtime.sendMessage(
          { action: "startSyncStatusPolling", token },
          (response) => {
            if (chrome.runtime.lastError) {
              console.error("启动轮询失败:", chrome.runtime.lastError);
              resolve(false);
            } else if (response == null ? void 0 : response.success) {
              console.log("Background轮询已启动");
              resolve(true);
            } else {
              console.error("启动轮询失败:", response == null ? void 0 : response.error);
              resolve(false);
            }
          }
        );
      });
    });
  }
  /**
   * 停止同步状态轮询
   */
  static stopSyncStatusPolling() {
    return __async(this, null, function* () {
      return new Promise((resolve) => {
        chrome.runtime.sendMessage(
          { action: "stopSyncStatusPolling" },
          (response) => {
            if (chrome.runtime.lastError) {
              console.error("停止轮询失败:", chrome.runtime.lastError);
              resolve(false);
            } else if (response == null ? void 0 : response.success) {
              console.log("Background轮询已停止");
              resolve(true);
            } else {
              console.error("停止轮询失败:", response == null ? void 0 : response.error);
              resolve(false);
            }
          }
        );
      });
    });
  }
  /**
   * 监听同步状态更新
   * @param callback 状态更新回调函数
   */
  static onSyncStatusUpdate(callback) {
    chrome.runtime.onMessage.addListener((request, _sender, _sendResponse) => {
      if (request.action === "syncStatusUpdated" && request.data) {
        console.log("收到Background状态更新:", request.data);
        callback(request.data);
      }
    });
  }
}
function pollWithRetry(_0) {
  return __async(this, arguments, function* (pollFunction, config = {}) {
    const {
      interval = 200,
      maxAttempts = 50,
      description = "轮询操作"
    } = config;
    let attempts = 0;
    let lastError = null;
    console.log(`🔄 开始${description}，轮询间隔${interval}ms，最大尝试${maxAttempts}次`);
    while (attempts < maxAttempts) {
      attempts++;
      try {
        console.log(`🔍 [${Date.now()}] ${description} - 第${attempts}次尝试`);
        const result = yield pollFunction();
        if (result !== null && result !== void 0) {
          console.log(`✅ [${Date.now()}] ${description} - 第${attempts}次尝试成功`);
          return {
            success: true,
            data: result,
            attempts
          };
        }
        console.log(`⚠️ [${Date.now()}] ${description} - 第${attempts}次尝试未成功，继续轮询`);
      } catch (error) {
        lastError = error instanceof Error ? error : new Error(String(error));
        console.error(`❌ [${Date.now()}] ${description} - 第${attempts}次尝试出错:`, lastError);
      }
      if (attempts < maxAttempts) {
        yield new Promise((resolve) => setTimeout(resolve, interval));
      }
    }
    const errorMessage = lastError ? lastError.message : "未知错误";
    console.error(`❌ [${Date.now()}] ${description} - 经过${maxAttempts}次尝试后失败: ${errorMessage}`);
    return {
      success: false,
      error: errorMessage,
      attempts
    };
  });
}
function waitForPageLoad(_0) {
  return __async(this, arguments, function* (loadingIndicator, config = {}) {
    return pollWithRetry(
      () => __async(this, null, function* () {
        if (loadingIndicator) ;
        const body = document.body;
        if (body && body.children.length > 0) {
          return true;
        }
        return null;
      }),
      __spreadValues({
        description: "等待页面加载完成"
      }, config)
    );
  });
}
function waitForChromeMessage(_0, _1) {
  return __async(this, arguments, function* (messageAction, sendMessageFunction, config = {}) {
    return pollWithRetry(
      () => __async(this, null, function* () {
        try {
          const response = yield sendMessageFunction();
          if (response && typeof response === "object" && "success" in response) {
            if (response.success) {
              return response.data !== void 0 ? response.data : response;
            } else {
              throw new Error(response.message || "消息处理失败");
            }
          }
          return response;
        } catch (error) {
          if (error instanceof Error && (error.message.includes("Receiving end does not exist") || error.message.includes("Could not establish connection"))) {
            return null;
          }
          throw error;
        }
      }),
      __spreadValues({
        description: `等待Chrome消息响应: ${messageAction}`
      }, config)
    );
  });
}
class SycmSyncService {
  constructor(userInfo, taskState, callbacks) {
    __publicField(this, "userInfo");
    __publicField(this, "taskState");
    __publicField(this, "callbacks");
    __publicField(this, "isStage1InProgress", false);
    this.userInfo = userInfo;
    this.taskState = taskState;
    this.callbacks = callbacks;
  }
  /**
   * 生意参谋收集任务点击
   */
  handleSycmClick() {
    return __async(this, null, function* () {
      try {
        if (this.taskState.sycmStatus === TaskStatus.COMPLETED || this.taskState.isSycmTaskProcessing) {
          return;
        }
        this.callbacks.setSycmTaskProcessing(true);
        yield this.callbacks.stopBackgroundPolling();
        yield this.executeSycmSync();
        this.callbacks.setTaskCompleted();
      } catch (error) {
        logError(error, "同步生意参谋", {
          additionalInfo: "同步过程中发生错误"
        });
        const errorMessage = error instanceof Error ? error.message : "同步生意参谋失败，请重试";
        UnifiedDialogManager.showError(errorMessage);
        this.callbacks.setTaskError();
        yield this.callbacks.resumeBackgroundPolling();
        this.callbacks.setSycmTaskProcessing(false);
      }
    });
  }
  /**
   * 同步生意参谋完整流程（平铺实现）
   */
  executeSycmSync() {
    return __async(this, null, function* () {
      if (this.isStage1InProgress) {
        return;
      }
      this.isStage1InProgress = true;
      try {
        const tabs = yield chrome.tabs.query({ active: true, currentWindow: true });
        if (!tabs[0] || !tabs[0].id) {
          throw new Error("未找到活动标签页，请确定浏览器功能正常，刷新后再重新点击生意参谋收集任务");
        }
        const tabId = tabs[0].id;
        yield this.validateSycmUserAccount(tabId);
        yield this.executeSycmDataCollection(tabId);
      } catch (error) {
        logError(error, "同步生意参谋流程", {
          additionalInfo: "同步过程中发生错误"
        });
        throw error;
      } finally {
        this.isStage1InProgress = false;
      }
    });
  }
  /**
   * 生意参谋用户信息一致性校验（封装方法）
   */
  validateSycmUserAccount(tabId) {
    return __async(this, null, function* () {
      try {
        const targetUrl = "https://sycm.taobao.com/custom/user_info";
        yield chrome.tabs.update(tabId, { url: targetUrl });
        const pageLoadResult = yield waitForPageLoad(void 0, {
          description: "等待生意参谋用户信息页面加载完成"
        });
        if (!pageLoadResult.success) {
          console.warn("页面加载等待超时，但继续执行后续流程");
        }
        const taobaoId = yield this.sycmCollectTaobaoId(tabId);
        if (!taobaoId) {
          throw new Error("账户验证失败，登录生意参谋的账户需要为店铺子账户，请确认后再使用！");
        }
        const isValid = yield this.validateSycmAccount(taobaoId);
        if (!isValid) {
          throw new Error("当前登录的账号与生意参谋账号不一致，请确认后再使用！");
        }
      } catch (error) {
        logError(error, "生意参谋用户信息一致性校验", {
          additionalInfo: `标签页ID: ${tabId}`
        });
        throw error;
      }
    });
  }
  /**
  * 抓取生意参谋taobaoId
  */
  sycmCollectTaobaoId(tabId) {
    return __async(this, null, function* () {
      try {
        const { sendMessageToContent: sendMessageToContent2 } = useChromeAPI();
        const messageResult = yield waitForChromeMessage(
          "msgSycmTaobaoIdCollect",
          () => sendMessageToContent2({
            action: "msgSycmTaobaoIdCollect"
          }),
          {
            description: "等待收集生意参谋用户账号信息"
          }
        );
        if (!messageResult.success) {
          logError(messageResult.error, "收集生意参谋用户账号信息", {
            additionalInfo: `标签页ID: ${tabId}`
          });
          return null;
        }
        const taobaoId = messageResult.data;
        if (taobaoId && typeof taobaoId === "string" && taobaoId.trim()) {
          return taobaoId;
        } else {
          return null;
        }
      } catch (error) {
        logError(error, "抓取生意参谋taobaoId", {
          additionalInfo: `标签页ID: ${tabId}`
        });
        return null;
      }
    });
  }
  /**
   * 生意参谋账号校验
   */
  validateSycmAccount(taobaoId) {
    return __async(this, null, function* () {
      try {
        const response = yield validateAccountAPI({ taobaoId }, this.userInfo.token);
        if (response.code === "0" && response.data) {
          return true;
        }
        return false;
      } catch (error) {
        logError(error, "生意参谋账号校验", { additionalInfo: "校验过程中发生错误" });
        return false;
      }
    });
  }
  /**
   * 执行生意参谋数据收集流程（新的实现，参考万相台提交方式）
   */
  executeSycmDataCollection(tabId) {
    return __async(this, null, function* () {
      try {
        const yesterday = this.getYesterdayDateString();
        const targetUrl = `https://sycm.taobao.com/cc/item_rank?dateRange=${yesterday}%7C${yesterday}&dateType=day`;
        yield chrome.tabs.update(tabId, { url: targetUrl });
        const pageLoadResult = yield waitForPageLoad(void 0, {
          description: "等待生意参谋数据收集页面加载完成"
        });
        if (!pageLoadResult.success) {
          console.warn("页面加载等待超时，但继续执行后续流程");
        }
        const { sendMessageToContent: sendMessageToContent2 } = useChromeAPI();
        const messageResult = yield waitForChromeMessage(
          "msgSycmDataDownload",
          () => sendMessageToContent2({
            action: "msgSycmDataDownload"
          }),
          {
            description: "等待执行生意参谋数据下载"
          }
        );
        if (!messageResult.success) {
          throw new Error(`生意参谋数据下载失败: ${messageResult.error || "未知错误"}`);
        }
      } catch (error) {
        logError(error, "执行生意参谋数据收集流程", {
          additionalInfo: `标签页ID: ${tabId}`
        });
        throw error;
      }
    });
  }
  /**
   * 获取前一日日期字符串（格式：2025-10-01）
   */
  getYesterdayDateString() {
    const yesterday = /* @__PURE__ */ new Date();
    yesterday.setDate(yesterday.getDate() - 1);
    const year = yesterday.getFullYear();
    const month = String(yesterday.getMonth() + 1).padStart(2, "0");
    const day = String(yesterday.getDate()).padStart(2, "0");
    return `${year}-${month}-${day}`;
  }
  /**
   * 处理生意参谋文件选择
   */
  handleSycmFileSelected(file) {
    return __async(this, null, function* () {
      try {
        const fileBuffer = yield file.arrayBuffer();
        const fileBufferArray = Array.from(new Uint8Array(fileBuffer));
        const response = yield chrome.runtime.sendMessage({
          action: "syncSycm",
          token: this.userInfo.token,
          fileName: file.name,
          fileType: file.type,
          fileBuffer: fileBufferArray
        });
        if (!response.success) {
          throw new Error(response.message || "生意参谋同步失败");
        }
        this.callbacks.setSycmFileUploaded(true);
        this.callbacks.setSycmTaskProcessing(false);
        yield this.callbacks.resumeBackgroundPolling();
      } catch (error) {
        logError(error, "生意参谋文件同步", {
          additionalInfo: "文件上传或同步过程中发生错误"
        });
        UnifiedDialogManager.showError("生意参谋文件同步失败，请重试");
        this.callbacks.setTaskCompleted();
        throw error;
      }
    });
  }
}
function createSycmSyncService(userInfo, taskState, callbacks) {
  return new SycmSyncService(userInfo, taskState, callbacks);
}
class WxtSyncPnlService {
  constructor(userInfo, taskState, callbacks) {
    __publicField(this, "userInfo");
    __publicField(this, "taskState");
    __publicField(this, "callbacks");
    __publicField(this, "isStage1InProgress", false);
    this.userInfo = userInfo;
    this.taskState = taskState;
    this.callbacks = callbacks;
  }
  /**
   * 万相台收集任务点击
   */
  handleWxtClick() {
    return __async(this, null, function* () {
      try {
        if (this.taskState.wxtStatus === TaskStatus.COMPLETED || this.taskState.isWxtTaskProcessing) {
          return;
        }
        this.callbacks.setWxtTaskProcessing(true);
        this.callbacks.setWxtStageStatus(StageStatus.COLLECTING);
        yield this.callbacks.stopBackgroundPolling();
        yield this.msgWxtDataCollect();
        this.callbacks.setTaskCompleted();
      } catch (error) {
        console.error("万相台数据收集失败:", error);
        const errorMessage = error instanceof Error ? error.message : "万相台数据收集失败，请重试";
        UnifiedDialogManager.showError(errorMessage);
        this.callbacks.setTaskError();
        yield this.callbacks.resumeBackgroundPolling();
        this.callbacks.setWxtTaskProcessing(false);
      }
    });
  }
  /**
   * 万相台数据收集流程（新的实现，参考生意参谋）
   */
  msgWxtDataCollect() {
    return __async(this, null, function* () {
      if (this.isStage1InProgress) {
        return;
      }
      this.isStage1InProgress = true;
      try {
        const tabs = yield chrome.tabs.query({ active: true, currentWindow: true });
        if (!tabs[0] || !tabs[0].id) {
          throw new Error("未找到活动标签页");
        }
        const tabId = tabs[0].id;
        yield this.validateWxtUserAccount(tabId);
        yield this.msgWxtDataCollectFlow(tabId);
      } catch (error) {
        console.error("万相台数据收集流程失败:", error);
        logError(error, "万相台数据收集流程", {
          additionalInfo: "数据收集过程中发生错误"
        });
        const errorMessage = error instanceof Error ? error.message : "万相台数据收集过程中发生未知错误";
        UnifiedDialogManager.showError(`万相台数据收集失败：${errorMessage}`);
        throw error;
      } finally {
        this.isStage1InProgress = false;
      }
    });
  }
  /**
   * 万相台用户信息一致性校验（封装方法）
   */
  validateWxtUserAccount(tabId) {
    return __async(this, null, function* () {
      try {
        console.log("开始执行万相台用户信息一致性校验");
        const targetUrl = "https://one.alimama.com/index.html#!/account/base";
        console.log("跳转到万相台用户信息页面:", targetUrl);
        yield chrome.tabs.update(tabId, { url: targetUrl });
        console.log("⏳ 等待万相台用户信息页面加载完成...");
        const pageLoadResult = yield waitForPageLoad(void 0, {
          description: "等待万相台用户信息页面加载完成"
        });
        if (!pageLoadResult.success) {
          console.warn("⚠️ 页面加载等待超时，但继续执行后续流程");
        } else {
          console.log("✅ 万相台用户信息页面加载完成");
        }
        console.log("开始抓取万相台用户taobaoId");
        const taobaoId = yield this.wxtCollectTaobaoId(tabId);
        if (!taobaoId) {
          throw new Error("万相台taobaoId抓取失败");
        }
        console.log("成功抓取到万相台taobaoId:", taobaoId);
        console.log("开始执行万相台用户信息一致性校验");
        const isValid = yield this.validateWxtAccount(taobaoId);
        if (!isValid) {
          throw new Error("当前登录的账号与万相台账号不一致，请确认后再使用！");
        }
        console.log("✅ 万相台用户信息校验成功");
      } catch (error) {
        console.error("万相台用户信息一致性校验失败:", error);
        logError(error, "万相台用户信息一致性校验", {
          additionalInfo: `标签页ID: ${tabId}`
        });
        throw error;
      }
    });
  }
  /**
   * 抓取万相台taobaoId
   */
  wxtCollectTaobaoId(tabId) {
    return __async(this, null, function* () {
      try {
        console.log("=== 开始抓取万相台taobaoId ===");
        console.log("目标标签页ID:", tabId);
        const { sendMessageToContent: sendMessageToContent2 } = useChromeAPI();
        console.log("发送消息: msgWxtTaobaoIdCollect（万相台）");
        const messageResult = yield waitForChromeMessage(
          "msgWxtTaobaoIdCollect",
          () => sendMessageToContent2({
            action: "msgWxtTaobaoIdCollect"
          }),
          {
            description: "等待收集万相台用户账号信息"
          }
        );
        if (!messageResult.success) {
          console.error("收集万相台用户账号信息失败:", messageResult.error);
          return null;
        }
        const taobaoId = messageResult.data;
        console.log("收到响应:", taobaoId);
        console.log("响应类型检查:");
        console.log("- taobaoId存在:", !!taobaoId);
        console.log("- taobaoId类型:", typeof taobaoId);
        if (taobaoId && typeof taobaoId === "string" && taobaoId.trim()) {
          console.log("✅ 成功抓取到万相台taobaoId:", taobaoId);
          return taobaoId;
        } else {
          console.log("❌ 万相台taobaoId抓取失败或为空");
          console.log("⚠️ 未找到taobaoId，可能原因:");
          console.log("1. 页面元素结构发生变化");
          console.log("2. 页面还未完全加载");
          console.log("3. 用户未登录或权限不足");
          console.log("4. 页面URL不正确");
          return null;
        }
      } catch (error) {
        console.error("抓取万相台taobaoId失败:", error);
        logError(error, "抓取万相台taobaoId", {
          additionalInfo: `标签页ID: ${tabId}, 页面URL: ${window.location.href}`
        });
        return null;
      }
    });
  }
  /**
   * 万相台账号校验
   */
  validateWxtAccount(taobaoId) {
    return __async(this, null, function* () {
      try {
        const response = yield validateAccountAPI({ taobaoId }, this.userInfo.token);
        console.log("万相台账号校验响应:", response);
        console.log("校验的taobaoId:", taobaoId);
        if (response.code === "0" && response.data) {
          return true;
        }
        return false;
      } catch (error) {
        console.error("万相台账号校验出错:", error);
        logError(error, "万相台账号校验", { additionalInfo: "校验过程中发生错误" });
        return false;
      }
    });
  }
  /**
   * 执行万相台数据收集流程（通过content script处理）
   */
  msgWxtDataCollectFlow(tabId, maxRetries = 2) {
    return __async(this, null, function* () {
      let lastError = null;
      for (let attempt = 1; attempt <= maxRetries; attempt++) {
        try {
          console.log(`开始执行万相台数据收集流程 (第${attempt}次尝试)`);
          console.log("跳转到万相台数据收集页面");
          const targetUrl = "https://one.alimama.com/index.html#!/manage/onesite?offset=0&pageSize=100";
          yield chrome.tabs.update(tabId, { url: targetUrl });
          console.log("⏳ 等待万相台数据收集页面加载完成...");
          const pageLoadResult = yield waitForPageLoad(void 0, {
            description: "等待万相台数据收集页面加载完成"
          });
          if (!pageLoadResult.success) {
            console.warn("⚠️ 页面加载等待超时，但继续执行后续流程");
          } else {
            console.log("✅ 万相台数据收集页面加载完成");
          }
          console.log("开始执行万相台数据收集配置");
          const { sendMessageToContent: sendMessageToContent2 } = useChromeAPI();
          const messageResult = yield waitForChromeMessage(
            "msgWxtDataCollect",
            () => sendMessageToContent2({
              action: "msgWxtDataCollect"
            }, 12e4),
            // 设置2分钟超时时间
            {
              description: "等待执行万相台数据收集配置"
            }
          );
          if (!messageResult.success) {
            throw new Error(`万相台数据收集配置执行失败: ${messageResult.error}`);
          }
          console.log("✅ 万相台数据收集流程执行成功");
          return;
        } catch (error) {
          lastError = error instanceof Error ? error : new Error(String(error));
          console.error(`执行万相台数据收集流程失败 (第${attempt}次尝试):`, lastError);
          logError(lastError, "执行万相台数据收集流程", {
            additionalInfo: `标签页ID: ${tabId}, 尝试次数: ${attempt}/${maxRetries}`
          });
          if (attempt < maxRetries) {
            console.log(`等待后进行第${attempt + 1}次重试...`);
            const retryWaitResult = yield waitForPageLoad(void 0, {
              description: "重试前等待",
              maxAttempts: 15
              // 重试等待时间较短（3秒）
            });
            if (!retryWaitResult.success) {
              console.warn("⚠️ 重试等待超时，但继续重试");
            }
          }
        }
      }
      if (lastError) {
        const enhancedError = new Error(`万相台数据收集流程执行失败，已重试${maxRetries}次: ${lastError.message}`);
        enhancedError.message += `
原始错误: ${lastError.message}`;
        throw enhancedError;
      } else {
        throw new Error("万相台数据收集流程执行失败，未知错误");
      }
    });
  }
}
function createWxtSyncPnlService(userInfo, taskState, callbacks) {
  return new WxtSyncPnlService(userInfo, taskState, callbacks);
}
const _hoisted_1$3 = { class: "sync-tasks-overlay" };
const _hoisted_2$3 = { class: "tasks-container" };
const _hoisted_3$3 = { class: "task-list" };
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "SyncTasks",
  props: {
    userInfo: {},
    sycmStatus: {},
    wxtStatus: {}
  },
  emits: ["sync-completed"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const pollingInterval = ref(null);
    const isPolling = ref(false);
    const pauseTimeout = ref(null);
    const sycmTaskItem = ref(null);
    const wxtTaskItem = ref(null);
    let sycmSyncService = null;
    let wxtSyncPnlService = null;
    const { sycmStatus, wxtStatus } = useGlobalState();
    const isSycmTaskProcessing = ref(false);
    const isWxtTaskProcessing = ref(false);
    const isSycmFileUploaded = ref(false);
    let backgroundMessageListener = null;
    const handleBackgroundStatusUpdate = (data) => {
      console.log("SyncTasks.vue收到Background状态更新:", data);
      if (!data || typeof data !== "object") {
        console.error("Background状态数据格式错误:", data);
        return;
      }
      const { sycm, wxt } = data;
      if (typeof sycm === "number") {
        if (sycm === 0) {
          if (props.sycmStatus === TaskStatus.SYNCING) {
            GlobalStateManager.updateSycmStatus(TaskStatus.SYNCING, "sync-tasks-background-sycm-keep");
          } else {
            GlobalStateManager.updateSycmStatus(TaskStatus.PENDING, "sync-tasks-background-sycm-reset");
          }
        } else if (sycm === 1) {
          GlobalStateManager.updateSycmStatus(TaskStatus.SYNCING, "sync-tasks-background-sycm-syncing");
        } else if (sycm === 2) {
          GlobalStateManager.updateSycmStatus(TaskStatus.COMPLETED, "sync-tasks-background-sycm-completed");
        } else if (sycm === 3) {
          GlobalStateManager.updateSycmStatus(TaskStatus.FAILED, "sync-tasks-background-sycm-failed");
        }
      }
      if (typeof wxt === "number") {
        if (wxt === 0) {
          if (props.wxtStatus === TaskStatus.SYNCING) {
            GlobalStateManager.updateWxtStatus(TaskStatus.SYNCING, "sync-tasks-background-wxt-keep");
          } else {
            GlobalStateManager.updateWxtStatus(TaskStatus.PENDING, "sync-tasks-background-wxt-reset");
          }
        } else if (wxt === 1) {
          if (props.wxtStatus === TaskStatus.PENDING) {
            console.log("万相台正在收集阶段，保持PENDING状态，不更新全局状态");
          } else {
            GlobalStateManager.updateWxtStatus(TaskStatus.SYNCING, "sync-tasks-background-wxt-syncing");
          }
        } else if (wxt === 2) {
          GlobalStateManager.updateWxtStatus(TaskStatus.COMPLETED, "sync-tasks-background-wxt-completed");
        } else if (wxt === 3) {
          GlobalStateManager.updateWxtStatus(TaskStatus.FAILED, "sync-tasks-background-wxt-failed");
        }
      }
      if (typeof sycm === "number" && typeof wxt === "number") {
        if (sycm === 2 && wxt === 2) {
          if (window.__justResynced) {
            const resyncStartTime = window.__resyncStartTime || 0;
            const timeSinceResync = Date.now() - resyncStartTime;
            console.log(`✅ 检测到两个同步任务都已完成，但刚刚进行了重新同步，跳过自动跳转 (${timeSinceResync}ms前)`);
            return;
          }
          console.log("✅ 检测到两个同步任务都已完成，触发自动跳转到数据列表页面");
          setTimeout(() => __async(this, null, function* () {
            yield stopBackgroundPolling();
            emit("sync-completed");
          }), 500);
        }
      }
    };
    const setupBackgroundListener = () => {
      backgroundMessageListener = (request) => {
        if (request.action === "syncStatusUpdated") {
          handleBackgroundStatusUpdate(request.data);
        } else if (request.action === "navigateToUrl") {
          handleNavigateToUrl(request.url);
        }
      };
      chrome.runtime.onMessage.addListener(backgroundMessageListener);
    };
    const handleNavigateToUrl = (url) => __async(this, null, function* () {
      try {
        console.log("收到页面跳转请求:", url);
        const tabs = yield chrome.tabs.query({ active: true, currentWindow: true });
        if (!tabs[0] || !tabs[0].id) {
          throw new Error("未找到活动标签页");
        }
        yield chrome.tabs.update(tabs[0].id, { url });
        console.log("✅ 页面跳转完成:", url);
      } catch (error) {
        console.error("页面跳转失败:", error);
        logError(error, "页面跳转", {
          additionalInfo: `目标URL: ${url}`
        });
      }
    });
    const cleanupBackgroundListener = () => {
      if (backgroundMessageListener) {
        chrome.runtime.onMessage.removeListener(backgroundMessageListener);
        backgroundMessageListener = null;
      }
    };
    const initSycmSyncService = () => {
      if (!sycmSyncService) {
        sycmSyncService = createSycmSyncService(
          props.userInfo,
          {
            sycmStatus: sycmStatus.value,
            sycmStageStatus: void 0,
            // 阶段状态由SyncTaskItem内部管理
            isSycmTaskProcessing: isSycmTaskProcessing.value,
            isSycmFileUploaded: isSycmFileUploaded.value
          },
          {
            setSycmTaskProcessing: (processing) => {
              isSycmTaskProcessing.value = processing;
            },
            setSycmFileUploaded: (uploaded) => {
              isSycmFileUploaded.value = uploaded;
            },
            setSycmStageStatus: (_status) => {
            },
            setTaskCompleted: () => {
              var _a;
              (_a = sycmTaskItem.value) == null ? void 0 : _a.setTaskCompleted();
            },
            setTaskError: () => {
              var _a;
              (_a = sycmTaskItem.value) == null ? void 0 : _a.setTaskError();
            },
            stopBackgroundPolling,
            resumeBackgroundPolling
          }
        );
      }
    };
    const handleSycmClick = (event) => __async(this, null, function* () {
      initSycmSyncService();
      if (sycmSyncService) {
        yield sycmSyncService.handleSycmClick();
      }
    });
    const initWxtSyncPnlService = () => {
      if (!wxtSyncPnlService) {
        wxtSyncPnlService = createWxtSyncPnlService(
          props.userInfo,
          {
            wxtStatus: wxtStatus.value,
            wxtStageStatus: void 0,
            // 阶段状态由SyncTaskItem内部管理
            isWxtTaskProcessing: isWxtTaskProcessing.value
          },
          {
            setWxtTaskProcessing: (processing) => {
              isWxtTaskProcessing.value = processing;
            },
            setWxtStageStatus: (status) => {
              if (wxtTaskItem.value) {
                if (status === StageStatus.COLLECTING) {
                  wxtTaskItem.value.setTaskCollecting();
                } else if (status === StageStatus.COLLECT_COMPLETED) {
                  wxtTaskItem.value.setTaskCompleted();
                } else if (status === StageStatus.COLLECT_ERROR) {
                  wxtTaskItem.value.setTaskError();
                }
              }
            },
            setTaskCompleted: () => {
              var _a;
              (_a = wxtTaskItem.value) == null ? void 0 : _a.setTaskCompleted();
            },
            setTaskError: () => {
              var _a;
              (_a = wxtTaskItem.value) == null ? void 0 : _a.setTaskError();
            },
            stopBackgroundPolling,
            resumeBackgroundPolling,
            handleNavigateToUrl,
            updateWxtStatus: (status) => {
              GlobalStateManager.updateWxtStatus(status, "sync-tasks-wxt-handler");
            }
          }
        );
      }
    };
    const handleWxtClick = () => __async(this, null, function* () {
      initWxtSyncPnlService();
      if (wxtSyncPnlService) {
        yield wxtSyncPnlService.handleWxtClick();
      }
    });
    const isWxtDisabled = computed(() => {
      if (isSycmTaskProcessing.value) {
        return true;
      }
      if (sycmStatus.value === TaskStatus.PENDING && wxtStatus.value === TaskStatus.PENDING) {
        return true;
      }
      return false;
    });
    const isSycmOrangeStyle = computed(() => {
      if (sycmStatus.value === TaskStatus.PENDING && wxtStatus.value === TaskStatus.PENDING) {
        return true;
      }
      return false;
    });
    const handleSycmFileSelected = (file) => __async(this, null, function* () {
      initSycmSyncService();
      if (!sycmSyncService) {
        return;
      }
      try {
        yield sycmSyncService.handleSycmFileSelected(file);
        yield checkWxtStatusAndHandle();
      } catch (error) {
        const errorMsg = error instanceof Error ? error.message : "未知错误";
        console.error("[SYNC-TASKS] 生意参谋文件处理失败:", errorMsg);
      }
    });
    const checkWxtStatusAndHandle = () => __async(this, null, function* () {
      try {
        const currentStatus = yield BackgroundStateClient.fetchSyncStatusOnce(props.userInfo.token);
        if (!currentStatus) {
          console.warn("[SYNC-TASKS] 无法获取万相台状态");
          return;
        }
        const { wxt } = currentStatus;
        const { mapSyncStatusFromAPI: mapSyncStatusFromAPI2 } = yield __vitePreload(() => __async(this, null, function* () {
          const { mapSyncStatusFromAPI: mapSyncStatusFromAPI3 } = yield Promise.resolve().then(() => stateManager);
          return { mapSyncStatusFromAPI: mapSyncStatusFromAPI3 };
        }), true ? void 0 : void 0, import.meta.url);
        const mappedStatus = mapSyncStatusFromAPI2({ sycm: 0, wxt });
        if (mappedStatus.wxtStatus === TaskStatus.COMPLETED) {
          return;
        }
        initWxtSyncPnlService();
        if (wxtSyncPnlService) {
          try {
            yield wxtSyncPnlService.handleWxtClick();
          } catch (error) {
            const errorMsg = error instanceof Error ? error.message : "未知错误";
            console.error("[SYNC-TASKS] 自动触发万相台收集失败:", errorMsg);
            logError(error, "自动触发万相台收集", {
              additionalInfo: "生意参谋同步完成后自动触发万相台收集失败"
            });
          }
        }
      } catch (error) {
        const errorMsg = error instanceof Error ? error.message : "未知错误";
        console.error("[SYNC-TASKS] 检查万相台状态失败:", errorMsg);
        logError(error, "检查万相台状态", {
          additionalInfo: "生意参谋同步完成后检查万相台状态失败"
        });
        initWxtSyncPnlService();
        if (wxtSyncPnlService) {
          try {
            yield wxtSyncPnlService.handleWxtClick();
          } catch (triggerError) {
            const triggerErrorMsg = triggerError instanceof Error ? triggerError.message : "未知错误";
            console.error("[SYNC-TASKS] 自动触发万相台收集失败:", triggerErrorMsg);
          }
        }
      }
    });
    const initStatusListener = () => __async(this, null, function* () {
      if (isPolling.value) {
        console.log("状态监听已在进行中，跳过");
        return;
      }
      console.log("开始监听Background状态更新并启动轮询");
      isPolling.value = true;
      try {
        const pollingStarted = yield BackgroundStateClient.startSyncStatusPolling(props.userInfo.token);
        if (pollingStarted) {
          console.log("✅ Background轮询启动成功");
        } else {
          console.error("❌ Background轮询启动失败");
        }
      } catch (error) {
        console.error("启动Background轮询出错:", error);
      }
      BackgroundStateClient.getCurrentSyncStatus().then((currentStatus) => {
        if (currentStatus) {
          console.log("获取到初始状态:", currentStatus);
          handleBackgroundStatusUpdate(currentStatus);
        } else {
          console.log("初始状态为空，等待Background轮询完成");
        }
      }).catch((error) => {
        console.error("获取初始状态失败:", error);
      });
    });
    const stopBackgroundPolling = () => __async(this, null, function* () {
      try {
        console.log("🛑 停止Background轮询（任务执行期间）...");
        const pollingStopped = yield BackgroundStateClient.stopSyncStatusPolling();
        if (pollingStopped) {
          console.log("✅ Background轮询停止成功");
        } else {
          console.error("❌ Background轮询停止失败");
        }
      } catch (error) {
        console.error("停止Background轮询出错:", error);
      }
    });
    const resumeBackgroundPolling = () => __async(this, null, function* () {
      try {
        console.log("🔄 恢复Background轮询（任务完成后）...");
        const pollingStarted = yield BackgroundStateClient.startSyncStatusPolling(props.userInfo.token);
        if (pollingStarted) {
          console.log("✅ Background轮询恢复成功");
        } else {
          console.error("❌ Background轮询恢复失败");
        }
      } catch (error) {
        console.error("恢复Background轮询出错:", error);
      }
    });
    const stopPolling = () => __async(this, null, function* () {
      if (pollingInterval.value) {
        clearInterval(pollingInterval.value);
        pollingInterval.value = null;
      }
      isPolling.value = false;
      try {
        const pollingStopped = yield BackgroundStateClient.stopSyncStatusPolling();
        if (pollingStopped) {
          console.log("✅ Background轮询停止成功");
        } else {
          console.error("❌ Background轮询停止失败");
        }
      } catch (error) {
        console.error("停止Background轮询出错:", error);
      }
      console.log("状态监听已停止");
    });
    onMounted(() => __async(this, null, function* () {
      console.log("SyncTasks组件已挂载，开始监听Background状态更新");
      setupBackgroundListener();
      yield initStatusListener();
    }));
    onUnmounted(() => __async(this, null, function* () {
      console.log("SyncTasks组件即将卸载，停止状态监听");
      cleanupBackgroundListener();
      yield stopPolling();
      if (pauseTimeout.value) {
        clearTimeout(pauseTimeout.value);
        pauseTimeout.value = null;
      }
    }));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$3, [
        createBaseVNode("div", _hoisted_2$3, [
          _cache[0] || (_cache[0] = createStaticVNode('<div class="sync-header" data-v-5752859f><div class="sync-icon" data-v-5752859f><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" data-v-5752859f><path d="M4 4V20H20V4H4ZM18 18H6V6H18V18Z" fill="currentColor" data-v-5752859f></path><path d="M8 8H16V10H8V8ZM8 12H16V14H8V12ZM8 16H12V18H8V16Z" fill="currentColor" data-v-5752859f></path></svg></div><div class="header-content" data-v-5752859f><div class="header-text" data-v-5752859f><h3 data-v-5752859f>数据同步</h3><p data-v-5752859f>请完成以下同步任务以查看数据</p></div></div></div>', 1)),
          createBaseVNode("div", _hoisted_3$3, [
            createVNode(SyncTaskItem, {
              ref_key: "sycmTaskItem",
              ref: sycmTaskItem,
              title: "同步生意参谋",
              description: "获取商品分析数据",
              "task-status": unref(sycmStatus),
              "allowed-file-types": ["xls"],
              disabled: isWxtTaskProcessing.value,
              "orange-style": isSycmOrangeStyle.value,
              "task-type": "sycm",
              "sync-button-clickable": true,
              onTaskClick: handleSycmClick,
              onFileSelected: handleSycmFileSelected
            }, null, 8, ["task-status", "disabled", "orange-style"]),
            createVNode(SyncTaskItem, {
              ref_key: "wxtTaskItem",
              ref: wxtTaskItem,
              title: "同步万相台",
              description: "获取推广数据",
              "task-status": unref(wxtStatus),
              "allowed-file-types": ["zip"],
              disabled: isWxtDisabled.value,
              "task-type": "wxt",
              "sync-button-clickable": false,
              onTaskClick: handleWxtClick
            }, null, 8, ["task-status", "disabled"])
          ])
        ])
      ]);
    };
  }
});
const SyncTasks = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["__scopeId", "data-v-5752859f"]]);
function mapSyncStatusFromAPI(apiStatus) {
  const { sycm, wxt } = apiStatus;
  let sycmStatus;
  let sycmCompleted;
  if (sycm === 0) {
    sycmStatus = TaskStatus.PENDING;
    sycmCompleted = false;
  } else if (sycm === 1) {
    sycmStatus = TaskStatus.SYNCING;
    sycmCompleted = false;
  } else if (sycm === 2) {
    sycmStatus = TaskStatus.COMPLETED;
    sycmCompleted = true;
  } else if (sycm === 3) {
    sycmStatus = TaskStatus.FAILED;
    sycmCompleted = false;
  } else {
    sycmStatus = TaskStatus.PENDING;
    sycmCompleted = false;
  }
  let wxtStatus;
  let wxtCompleted;
  if (wxt === 0) {
    wxtStatus = TaskStatus.PENDING;
    wxtCompleted = false;
  } else if (wxt === 1) {
    wxtStatus = TaskStatus.SYNCING;
    wxtCompleted = false;
  } else if (wxt === 2) {
    wxtStatus = TaskStatus.COMPLETED;
    wxtCompleted = true;
  } else if (wxt === 3) {
    wxtStatus = TaskStatus.FAILED;
    wxtCompleted = false;
  } else {
    wxtStatus = TaskStatus.PENDING;
    wxtCompleted = false;
  }
  return {
    sycmStatus,
    wxtStatus,
    sycmCompleted,
    wxtCompleted
  };
}
const stateManager = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  mapSyncStatusFromAPI
}, Symbol.toStringTag, { value: "Module" }));
const _hoisted_1$2 = { class: "main-app" };
const _hoisted_2$2 = { class: "content-area" };
const _hoisted_3$2 = { class: "data-report-page" };
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "MainApp",
  props: {
    userInfo: {},
    sycmStatus: {},
    wxtStatus: {}
  },
  emits: ["logout"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const showDataTable = ref(false);
    const showSyncTasks = ref(false);
    const popupTableHeight = computed(() => {
      return 585 - 60 - 15 - 40;
    });
    const popupHeaderHeight = computed(() => {
      return 60 + 40;
    });
    const handleResyncCompleted = () => {
      console.log("🔄 [MAINAPP] 收到重新同步完成事件");
      console.log("🔄 [MAINAPP] 通过全局状态管理器重置状态: PENDING");
      GlobalStateManager.resetAllStatus("main-app-resync-completed");
      window.__justResynced = true;
      window.__resyncStartTime = Date.now();
      console.log("🔄 [MAINAPP] 设置重新同步标记，防止状态检查干扰");
      showDataTable.value = false;
      showSyncTasks.value = true;
      console.log("🔄 [MAINAPP] ✅ 页面已跳转到同步任务页面");
      console.log("🔄 [MAINAPP] 页面状态已更新:", { showDataTable: showDataTable.value, showSyncTasks: showSyncTasks.value });
    };
    const handleMaximizeRequested = () => {
      console.log("📱 [MAINAPP] 收到最大化请求事件");
    };
    const handleSyncCompleted = () => __async(this, null, function* () {
      console.log("✅ 收到同步完成事件，跳转到数据表格页面");
      showDataTable.value = true;
      showSyncTasks.value = false;
      GlobalStateManager.updateBothStatus(TaskStatus.COMPLETED, TaskStatus.COMPLETED, "main-app-sync-completed");
      yield stopPollingForDataTable();
    });
    const checkSyncStatusAndNavigate = () => __async(this, null, function* () {
      try {
        console.log("🔍 [STATUS_CHECK] 开始检查同步状态...");
        console.log("🔍 [STATUS_CHECK] 当前页面状态:", { showDataTable: showDataTable.value, showSyncTasks: showSyncTasks.value });
        if (window.__justResynced) {
          const resyncStartTime = window.__resyncStartTime || 0;
          const timeSinceResync = Date.now() - resyncStartTime;
          console.log(`🔍 [STATUS_CHECK] ⚠️ 刚刚进行了重新同步，跳过状态检查 (${timeSinceResync}ms前)`);
          console.log(`🔍 [STATUS_CHECK] 当前页面状态: showDataTable=${showDataTable.value}, showSyncTasks=${showSyncTasks.value}`);
          return;
        }
        console.log("🔍 [STATUS_CHECK] 调用Background获取同步状态...");
        const currentStatus = yield BackgroundStateClient.fetchSyncStatusOnce(props.userInfo.token);
        console.log("🔍 [STATUS_CHECK] 从Background获取的同步状态:", currentStatus);
        if (currentStatus) {
          const { sycm, wxt } = currentStatus;
          console.log("🔍 [STATUS_CHECK] 同步状态检查结果:", { sycm, wxt });
          const mappedStatus = mapSyncStatusFromAPI({ sycm, wxt });
          console.log("🔍 [STATUS_CHECK] 状态映射结果:", mappedStatus);
          if (mappedStatus.sycmStatus === TaskStatus.COMPLETED && mappedStatus.wxtStatus === TaskStatus.COMPLETED) {
            console.log("🔍 [STATUS_CHECK] ✅ 数据已同步完成，显示数据表格页面");
            console.log("🔍 [STATUS_CHECK] 页面跳转前状态:", { showDataTable: showDataTable.value, showSyncTasks: showSyncTasks.value });
            showDataTable.value = true;
            showSyncTasks.value = false;
            console.log("🔍 [STATUS_CHECK] 页面跳转后状态:", { showDataTable: showDataTable.value, showSyncTasks: showSyncTasks.value });
          } else {
            console.log("🔍 [STATUS_CHECK] ❌ 数据未同步完成，显示同步任务页面");
            console.log("🔍 [STATUS_CHECK] 页面跳转前状态:", { showDataTable: showDataTable.value, showSyncTasks: showSyncTasks.value });
            showDataTable.value = false;
            showSyncTasks.value = true;
            console.log("🔍 [STATUS_CHECK] 页面跳转后状态:", { showDataTable: showDataTable.value, showSyncTasks: showSyncTasks.value });
          }
          console.log("🔍 [STATUS_CHECK] 通过全局状态管理器更新状态:", mappedStatus);
          GlobalStateManager.updateBothStatus(mappedStatus.sycmStatus, mappedStatus.wxtStatus, "main-app-status-check");
        } else {
          console.log("🔍 [STATUS_CHECK] 直接调用失败，显示同步任务页面");
          console.log("🔍 [STATUS_CHECK] 页面跳转前状态:", { showDataTable: showDataTable.value, showSyncTasks: showSyncTasks.value });
          showDataTable.value = false;
          showSyncTasks.value = true;
          console.log("🔍 [STATUS_CHECK] 页面跳转后状态:", { showDataTable: showDataTable.value, showSyncTasks: showSyncTasks.value });
        }
      } catch (error) {
        console.error("🔍 [STATUS_CHECK] ❌ 检查同步状态出错:", error);
        console.log("🔍 [STATUS_CHECK] 出错，显示同步任务页面");
        console.log("🔍 [STATUS_CHECK] 页面跳转前状态:", { showDataTable: showDataTable.value, showSyncTasks: showSyncTasks.value });
        showDataTable.value = false;
        showSyncTasks.value = true;
        console.log("🔍 [STATUS_CHECK] 页面跳转后状态:", { showDataTable: showDataTable.value, showSyncTasks: showSyncTasks.value });
      }
    });
    const stopPollingForDataTable = () => __async(this, null, function* () {
      try {
        console.log("停止Background轮询（数据表页面）...");
        const pollingStopped = yield BackgroundStateClient.stopSyncStatusPolling();
        if (pollingStopped) {
          console.log("✅ Background轮询停止成功");
        } else {
          console.error("❌ Background轮询停止失败");
        }
      } catch (error) {
        console.error("停止Background轮询出错:", error);
      }
    });
    watch(() => [props.sycmStatus, props.wxtStatus], ([newSycmStatus, newWxtStatus], [oldSycmStatus, oldWxtStatus]) => {
      console.log("👀 [WATCH] Props状态发生变化:");
      console.log("👀 [WATCH] 生意参谋状态:", { old: oldSycmStatus, new: newSycmStatus });
      console.log("👀 [WATCH] 万相台状态:", { old: oldWxtStatus, new: newWxtStatus });
      console.log("👀 [WATCH] 当前页面状态:", { showDataTable: showDataTable.value, showSyncTasks: showSyncTasks.value });
      if (window.__justResynced) {
        const resyncStartTime = window.__resyncStartTime || 0;
        const timeSinceResync = Date.now() - resyncStartTime;
        console.log(`👀 [WATCH] ⚠️ 刚刚进行了重新同步，跳过自动页面跳转 (${timeSinceResync}ms前)`);
        return;
      }
      if (newSycmStatus === TaskStatus.COMPLETED && newWxtStatus === TaskStatus.COMPLETED) {
        console.log("👀 [WATCH] ✅ 两个任务都完成，自动跳转到数据表格页面");
        showDataTable.value = true;
        showSyncTasks.value = false;
      }
    }, { deep: true });
    watch([showDataTable, showSyncTasks], ([newShowDataTable, newShowSyncTasks], [oldShowDataTable, oldShowSyncTasks]) => {
      console.log("👀 [WATCH] 页面状态发生变化:");
      console.log("👀 [WATCH] showDataTable:", { old: oldShowDataTable, new: newShowDataTable });
      console.log("👀 [WATCH] showSyncTasks:", { old: oldShowSyncTasks, new: newShowSyncTasks });
      console.log("👀 [WATCH] 当前props状态:", { sycmStatus: props.sycmStatus, wxtStatus: props.wxtStatus });
    });
    onMounted(() => {
      console.log("🚀 [MOUNT] MainApp组件已挂载");
      console.log("🚀 [MOUNT] 当前页面状态:", { showDataTable: showDataTable.value, showSyncTasks: showSyncTasks.value });
      console.log("🚀 [MOUNT] 当前props状态:", { sycmStatus: props.sycmStatus, wxtStatus: props.wxtStatus });
      setTimeout(() => {
        console.log("🚀 [MOUNT] 开始延迟检查同步状态...");
        checkSyncStatusAndNavigate();
      }, 100);
      setTimeout(() => {
        if (!showDataTable.value && !showSyncTasks.value) {
          console.log("🚀 [MOUNT] ⚠️ 页面状态仍为false，默认显示同步任务页面");
          showSyncTasks.value = true;
        }
      }, 1e3);
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$2, [
        createBaseVNode("div", _hoisted_2$2, [
          createBaseVNode("div", _hoisted_3$2, [
            showDataTable.value ? (openBlock(), createBlock(PlanTable, {
              key: 0,
              items: [],
              "user-token": props.userInfo.token,
              "container-height": popupTableHeight.value,
              "header-height": popupHeaderHeight.value,
              "column-widths": {
                checkbox: "40px",
                product: "350px",
                quotaActual: "90px",
                quotaSuggest: "90px",
                priceActual: "90px",
                priceSuggest: "90px"
              },
              onResyncCompleted: handleResyncCompleted,
              onMaximizeRequested: handleMaximizeRequested
            }, null, 8, ["user-token", "container-height", "header-height"])) : createCommentVNode("", true),
            showSyncTasks.value ? (openBlock(), createBlock(SyncTasks, {
              key: 1,
              "user-info": _ctx.userInfo,
              "sycm-status": _ctx.sycmStatus,
              "wxt-status": _ctx.wxtStatus,
              onSyncCompleted: handleSyncCompleted
            }, null, 8, ["user-info", "sycm-status", "wxt-status"])) : createCommentVNode("", true)
          ])
        ])
      ]);
    };
  }
});
const MainApp = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["__scopeId", "data-v-7ce08adc"]]);
const _hoisted_1$1 = { class: "unified-dialog-header" };
const _hoisted_2$1 = { class: "unified-dialog-icon" };
const _hoisted_3$1 = { key: 0 };
const _hoisted_4$1 = { key: 1 };
const _hoisted_5$1 = { key: 2 };
const _hoisted_6$1 = { key: 3 };
const _hoisted_7$1 = { class: "unified-dialog-title" };
const _hoisted_8 = { class: "unified-dialog-content" };
const _hoisted_9 = ["innerHTML"];
const _hoisted_10 = { class: "unified-dialog-footer" };
const _hoisted_11 = ["disabled"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "UnifiedDialog",
  props: {
    visible: { type: Boolean },
    type: {},
    title: { default: "" },
    message: {},
    confirmText: { default: "确定" },
    cancelText: { default: "取消" },
    loadingText: { default: "处理中..." },
    showCancel: { type: Boolean, default: false },
    loading: { type: Boolean, default: false },
    allowOverlayClose: { type: Boolean, default: false }
  },
  emits: ["confirm", "cancel", "close"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const title = computed(() => {
      if (props.title) return props.title;
      switch (props.type) {
        case "warning":
          return "确认操作";
        case "error":
          return "操作异常";
        case "success":
          return "操作成功";
        case "info":
          return "提示信息";
        default:
          return "提示";
      }
    });
    const handleConfirm = () => {
      emit("confirm");
      emit("close");
    };
    const handleCancel = () => {
      emit("cancel");
      emit("close");
    };
    const handleOverlayClick = () => {
      if (props.allowOverlayClose) {
        emit("close");
      }
    };
    return (_ctx, _cache) => {
      return _ctx.visible ? (openBlock(), createElementBlock("div", {
        key: 0,
        class: "unified-dialog-overlay",
        onClick: handleOverlayClick
      }, [
        createBaseVNode("div", {
          class: "unified-dialog",
          onClick: _cache[0] || (_cache[0] = withModifiers(() => {
          }, ["stop"]))
        }, [
          createBaseVNode("div", _hoisted_1$1, [
            createBaseVNode("div", _hoisted_2$1, [
              _ctx.type === "warning" ? (openBlock(), createElementBlock("span", _hoisted_3$1, "⚠️")) : _ctx.type === "error" ? (openBlock(), createElementBlock("span", _hoisted_4$1, "❌")) : _ctx.type === "success" ? (openBlock(), createElementBlock("span", _hoisted_5$1, "✅")) : _ctx.type === "info" ? (openBlock(), createElementBlock("span", _hoisted_6$1, "ℹ️")) : createCommentVNode("", true)
            ]),
            createBaseVNode("div", _hoisted_7$1, toDisplayString(title.value), 1)
          ]),
          createBaseVNode("div", _hoisted_8, [
            createBaseVNode("p", {
              class: "unified-dialog-message",
              innerHTML: _ctx.message
            }, null, 8, _hoisted_9)
          ]),
          createBaseVNode("div", _hoisted_10, [
            createBaseVNode("button", {
              class: "unified-dialog-button confirm",
              onClick: handleConfirm,
              disabled: _ctx.loading
            }, toDisplayString(_ctx.loading ? _ctx.loadingText : _ctx.confirmText), 9, _hoisted_11),
            _ctx.showCancel ? (openBlock(), createElementBlock("button", {
              key: 0,
              class: "unified-dialog-button cancel",
              onClick: handleCancel
            }, toDisplayString(_ctx.cancelText), 1)) : createCommentVNode("", true)
          ])
        ])
      ])) : createCommentVNode("", true);
    };
  }
});
const UnifiedDialog = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["__scopeId", "data-v-d799f361"]]);
const _hoisted_1 = { id: "app" };
const _hoisted_2 = {
  key: 0,
  class: "loading-page"
};
const _hoisted_3 = {
  key: 1,
  class: "login-page"
};
const _hoisted_4 = {
  key: 2,
  class: "register-page"
};
const _hoisted_5 = {
  key: 3,
  class: "ad-page"
};
const _hoisted_6 = {
  key: 4,
  class: "main-page"
};
const _hoisted_7 = { class: "content-area" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "App",
  setup(__props) {
    const isLoading = ref(true);
    const isLoggedIn = ref(false);
    const userInfo = ref(null);
    const showRegister = ref(false);
    const showAdPage = ref(false);
    const { sycmStatus, wxtStatus } = useGlobalState();
    const showCustomAlert = ref(false);
    const customAlertTitle = ref("提示");
    const customAlertMessage = ref("");
    let messageListener = null;
    const handleLoginSuccess = (data) => {
      var _a;
      userInfo.value = {
        username: data.username,
        token: data.token,
        loginTime: Date.now(),
        rememberMe: true,
        accountType: data.accountType
      };
      isLoggedIn.value = true;
      isLoading.value = false;
      showAdPage.value = data.accountType === 0;
      console.log("登录成功处理:", {
        accountType: data.accountType,
        showAdPage: showAdPage.value,
        isLoggedIn: isLoggedIn.value,
        userInfo: userInfo.value
      });
      console.log("页面状态检查:", {
        isLoading: isLoading.value,
        isLoggedIn: isLoggedIn.value,
        showRegister: showRegister.value,
        showAdPage: showAdPage.value,
        userInfoAccountType: (_a = userInfo.value) == null ? void 0 : _a.accountType
      });
      console.log("App.vue userInfo 更新:", userInfo.value);
    };
    const handleSwitchToRegister = () => {
      showRegister.value = true;
      console.log("切换到注册页面");
    };
    const handleSwitchToLogin = () => {
      showRegister.value = false;
      console.log("切换到登录页面");
    };
    const handleRegisterSuccess = (userInfo2) => {
      console.log("注册成功:", userInfo2);
      showRegister.value = false;
    };
    const handleBackToLogin = () => {
      console.log("从广告页面返回登录");
      isLoggedIn.value = false;
      userInfo.value = null;
      showAdPage.value = false;
    };
    const handleContinueBasic = () => {
      console.log("用户选择继续使用基础版");
      showAdPage.value = false;
    };
    const showCustomAlertDialog = (message, title = "提示") => {
      customAlertTitle.value = title;
      customAlertMessage.value = message;
      showCustomAlert.value = true;
    };
    const closeCustomAlert = () => __async(this, null, function* () {
      showCustomAlert.value = false;
      customAlertTitle.value = "提示";
      customAlertMessage.value = "";
      GlobalStateManager.resetAllStatus("popup-app-custom-alert");
    });
    const handleLogout = () => __async(this, null, function* () {
      var _a;
      try {
        yield removeToken();
        isLoggedIn.value = false;
        userInfo.value = null;
        showAdPage.value = false;
        showRegister.value = false;
        BackgroundStateClient.stopSyncStatusPolling().then((success) => {
          if (success) {
            console.log("退出登录，Background轮询已停止");
          } else {
            console.error("退出登录，但Background轮询停止失败");
          }
        });
        try {
          const allWindows = yield chrome.windows.getAll({ populate: true });
          const fulllistWindows = allWindows.filter((window2) => {
            var _a2, _b;
            const url = ((_b = (_a2 = window2.tabs) == null ? void 0 : _a2[0]) == null ? void 0 : _b.url) || "";
            return url.includes("planfulllist/index.html") || url.includes("planfulllist2/index.html");
          });
          if (fulllistWindows.length > 0) {
            console.log(`找到 ${fulllistWindows.length} 个fulllist窗口，准备关闭`);
            for (const window2 of fulllistWindows) {
              if (window2.id) {
                yield chrome.windows.remove(window2.id);
                console.log(`已关闭fulllist窗口: ${window2.id}`);
              }
            }
            console.log("所有fulllist窗口已关闭");
            chrome.runtime.sendMessage({ action: "cleanupFulllistWindows" }, (response) => {
              if (response == null ? void 0 : response.success) {
                console.log("已通知background清理fulllist窗口状态");
              }
            });
          } else {
            console.log("没有找到打开的fulllist窗口");
          }
        } catch (error) {
          console.error("关闭fulllist窗口失败:", error);
        }
        try {
          const tabs = yield chrome.tabs.query({ active: true, currentWindow: true });
          if ((_a = tabs[0]) == null ? void 0 : _a.id) {
            yield chrome.tabs.sendMessage(tabs[0].id, { action: "userLogout" });
            console.log("已通知content script用户退出登录");
          }
        } catch (error) {
          console.log("通知content script失败（可能页面未加载content script）:", error);
        }
      } catch (error) {
        console.error("退出登录失败:", error);
      }
    });
    const checkLoginStatus = () => __async(this, null, function* () {
      var _a;
      try {
        console.log("开始检查登录状态...");
        const user = yield autoLogin();
        if (!user || !user.token) {
          console.log("未找到有效的token，跳转到登录页");
          isLoggedIn.value = false;
          userInfo.value = null;
          showAdPage.value = false;
          showRegister.value = false;
          isLoading.value = false;
          return;
        }
        console.log("找到本地token，开始检查版本信息...", {
          username: user.username,
          token: user.token.substring(0, 10) + "..."
        });
        try {
          const versionInfo = yield getLatestVersionAPI(user.token);
          console.log("✅ 版本检查完成，用户已登录", {
            currentVersion: versionInfo.currentVersion,
            latestVersion: versionInfo.latestVersion,
            needUpdate: versionInfo.needUpdate
          });
          userInfo.value = user;
          isLoggedIn.value = true;
          if (user.accountType === 0) {
            showAdPage.value = true;
            console.log("自动登录成功，免费用户显示广告页面", { accountType: user.accountType });
          } else {
            showAdPage.value = false;
            console.log("自动登录成功，付费用户显示主功能页面", { accountType: user.accountType });
          }
        } catch (error) {
          console.error("版本检查请求失败:", error);
          if (error.status === 401 || ((_a = error.message) == null ? void 0 : _a.includes("401"))) {
            console.log("❌ 收到401响应，Token已过期，跳转到登录页");
            yield removeToken();
            isLoggedIn.value = false;
            userInfo.value = null;
            showAdPage.value = false;
            showRegister.value = false;
          } else {
            console.error("网络错误，保持当前登录状态");
            userInfo.value = user;
            isLoggedIn.value = true;
            if (user.accountType === 0) {
              showAdPage.value = true;
              console.log("网络错误，免费用户显示广告页面", { accountType: user.accountType });
            } else {
              showAdPage.value = false;
              console.log("网络错误，付费用户显示主功能页面", { accountType: user.accountType });
            }
          }
        }
      } catch (error) {
        console.error("检查登录状态失败:", error);
        isLoggedIn.value = false;
        userInfo.value = null;
        showAdPage.value = false;
        showRegister.value = false;
      } finally {
        isLoading.value = false;
      }
    });
    const setupMessageListener = () => {
      if (messageListener) {
        console.log("清理已存在的消息监听器");
        chrome.runtime.onMessage.removeListener(messageListener);
      }
      console.log("设置消息监听器");
      messageListener = (request, _sender, _sendResponse) => {
        console.log("收到消息:", request.type || request.action, request.data || request.message);
        if (request.type === "AUTH_EXPIRED") {
          console.log("收到认证过期消息，自动跳转登录页");
          handleAuthExpired(request.message);
          return;
        }
        switch (request.action) {
          case "updateWxtStatus":
            console.log("收到万相台状态更新消息:", request.data);
            handleWxtStatusUpdate(request.data);
            break;
          case "syncFailure":
            console.log("收到同步失败消息:", request.data);
            handleSyncFailure(request.data);
            break;
        }
      };
      chrome.runtime.onMessage.addListener(messageListener);
    };
    const cleanupMessageListener = () => {
      if (messageListener) {
        console.log("清理消息监听器");
        chrome.runtime.onMessage.removeListener(messageListener);
        messageListener = null;
      }
    };
    const handleAuthExpired = (message) => __async(this, null, function* () {
      try {
        console.log("处理认证过期，直接跳转登录页:", message);
        isLoggedIn.value = false;
        userInfo.value = null;
        try {
          yield BackgroundStateClient.stopSyncStatusPolling();
          console.log("认证过期，Background轮询已停止");
        } catch (error) {
          console.error("停止Background轮询失败:", error);
        }
        GlobalStateManager.resetAllStatus("popup-app-logout");
        console.log("已自动跳转到登录页");
      } catch (error) {
        console.error("处理认证过期失败:", error);
      }
    });
    const handleWxtStatusUpdate = (data) => {
      console.log("处理万相台状态更新:", data);
      const status = data.status;
      if (status === "completed") {
        GlobalStateManager.updateWxtStatus(TaskStatus.COMPLETED, "popup-app-wxt-handler");
        showCustomAlertDialog("万相台同步完成！", "同步完成");
      } else if (status === "processing") {
        GlobalStateManager.updateWxtStatus(TaskStatus.SYNCING, "popup-app-wxt-handler");
      } else if (status === "failed") {
        GlobalStateManager.updateWxtStatus(TaskStatus.PENDING, "popup-app-wxt-handler");
        showCustomAlertDialog("万相台同步失败，请重试", "同步失败");
      } else if (status === "timeout") {
        GlobalStateManager.updateWxtStatus(TaskStatus.PENDING, "popup-app-wxt-handler");
        showCustomAlertDialog("万相台同步超时，请重试", "同步超时");
      } else if (status === "sync") {
        GlobalStateManager.updateWxtStatus(TaskStatus.PENDING, "popup-app-wxt-handler");
      }
      saveTaskStatus();
    };
    const handleSyncFailure = (data) => {
      console.log("处理同步失败:", data);
      const { message, sycm, wxt } = data;
      if (sycm === 3) {
        GlobalStateManager.updateSycmStatus(TaskStatus.FAILED, "popup-app-sync-failure");
      }
      if (wxt === 3) {
        GlobalStateManager.updateWxtStatus(TaskStatus.FAILED, "popup-app-sync-failure");
      }
      showCustomAlertDialog(message, "同步失败");
      saveTaskStatus();
    };
    onMounted(() => __async(this, null, function* () {
      console.log("🚀 [APP_MOUNT] App组件已挂载");
      yield GlobalStateManager.loadFromStorage();
      console.log("🚀 [APP_MOUNT] 全局状态已加载:", { sycmStatus: sycmStatus.value, wxtStatus: wxtStatus.value });
      yield checkLoginStatus();
      setupMessageListener();
      setTimeout(() => __async(this, null, function* () {
        console.log("🚀 [APP_MOUNT] 开始延迟加载任务状态...");
        yield loadTaskStatus();
      }), 500);
    }));
    onUnmounted(() => {
      console.log("App组件卸载，清理消息监听器");
      cleanupMessageListener();
    });
    const updateSycmStatus = (value) => __async(this, null, function* () {
      console.log("📊 [STATE] 更新生意参谋状态:", value);
      console.log("📊 [STATE] 更新前状态:", sycmStatus.value);
      GlobalStateManager.updateSycmStatus(value, "popup-app");
      console.log("📊 [STATE] 更新后状态:", sycmStatus.value);
      console.log("📊 [STATE] 生意参谋状态已通过全局状态管理器更新");
    });
    const updateWxtStatus = (value) => __async(this, null, function* () {
      console.log("📊 [STATE] 更新万相台状态:", value);
      console.log("📊 [STATE] 更新前状态:", wxtStatus.value);
      GlobalStateManager.updateWxtStatus(value, "popup-app");
      console.log("📊 [STATE] 更新后状态:", wxtStatus.value);
      console.log("📊 [STATE] 万相台状态已通过全局状态管理器更新");
    });
    const saveTaskStatus = () => __async(this, null, function* () {
      console.log("💾 [SAVE] 状态保存已由全局状态管理器自动处理");
    });
    const loadTaskStatus = () => __async(this, null, function* () {
      try {
        console.log("📂 [LOAD] 开始加载任务状态...");
        console.log("📂 [LOAD] 当前状态:", { sycmStatus: sycmStatus.value, wxtStatus: wxtStatus.value });
        if (window.__justResynced) {
          const resyncStartTime = window.__resyncStartTime || 0;
          const timeSinceResync = Date.now() - resyncStartTime;
          console.log(`📂 [LOAD] ⚠️ 检测到刚刚进行了重新同步，跳过状态加载以避免覆盖新状态 (${timeSinceResync}ms前)`);
          return;
        }
        console.log("📂 [LOAD] ✅ 任务状态已由全局状态管理器管理");
      } catch (error) {
        console.error("📂 [LOAD] ❌ 加载任务状态失败:", error);
      }
    });
    const handleDialogConfirm = () => __async(this, null, function* () {
      yield UnifiedDialogManager.handleConfirm();
    });
    const handleDialogCancel = () => {
      UnifiedDialogManager.handleCancel();
    };
    const handleDialogClose = () => {
      UnifiedDialogManager.handleClose();
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createVNode(PageHeader, {
          "user-info": userInfo.value,
          onLogout: handleLogout
        }, null, 8, ["user-info"]),
        isLoading.value ? (openBlock(), createElementBlock("div", _hoisted_2, [..._cache[2] || (_cache[2] = [
          createBaseVNode("div", { class: "loading-container" }, [
            createBaseVNode("div", { class: "loading-spinner" }),
            createBaseVNode("p", { class: "loading-text" }, "正在加载...")
          ], -1)
        ])])) : !isLoggedIn.value && !showRegister.value ? (openBlock(), createElementBlock("div", _hoisted_3, [
          createVNode(Login, {
            onLoginSuccess: handleLoginSuccess,
            onSwitchToRegister: handleSwitchToRegister
          })
        ])) : !isLoggedIn.value && showRegister.value ? (openBlock(), createElementBlock("div", _hoisted_4, [
          createVNode(Register, {
            onSwitchToLogin: handleSwitchToLogin,
            onRegisterSuccess: handleRegisterSuccess
          })
        ])) : isLoggedIn.value && showAdPage.value ? (openBlock(), createElementBlock("div", _hoisted_5, [
          createVNode(AdPage, {
            onContinueBasic: handleContinueBasic,
            onBackToLogin: handleBackToLogin
          })
        ])) : isLoggedIn.value && !showAdPage.value ? (openBlock(), createElementBlock("div", _hoisted_6, [
          createBaseVNode("div", _hoisted_7, [
            createVNode(MainApp, {
              "user-info": userInfo.value,
              "sycm-status": unref(sycmStatus),
              "wxt-status": unref(wxtStatus),
              onLogout: handleLogout,
              onUpdateSycmStatus: _cache[0] || (_cache[0] = (value) => updateSycmStatus(value)),
              onUpdateWxtStatus: _cache[1] || (_cache[1] = (value) => updateWxtStatus(value))
            }, null, 8, ["user-info", "sycm-status", "wxt-status"])
          ])
        ])) : createCommentVNode("", true),
        createVNode(UnifiedDialog, {
          visible: unref(dialogState).visible,
          type: unref(dialogState).type,
          title: unref(dialogState).title,
          message: unref(dialogState).message,
          "confirm-text": unref(dialogState).confirmText,
          "cancel-text": unref(dialogState).cancelText,
          "loading-text": unref(dialogState).loadingText,
          "show-cancel": unref(dialogState).showCancel,
          loading: unref(dialogState).loading,
          "allow-overlay-close": unref(dialogState).allowOverlayClose,
          onConfirm: handleDialogConfirm,
          onCancel: handleDialogCancel,
          onClose: handleDialogClose
        }, null, 8, ["visible", "type", "title", "message", "confirm-text", "cancel-text", "loading-text", "show-cancel", "loading", "allow-overlay-close"]),
        createVNode(UnifiedDialog, {
          visible: showCustomAlert.value,
          type: "warning",
          title: customAlertTitle.value,
          message: customAlertMessage.value,
          "confirm-text": "确定",
          "show-cancel": false,
          onConfirm: closeCustomAlert,
          onClose: closeCustomAlert
        }, null, 8, ["visible", "title", "message"])
      ]);
    };
  }
});
const App = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-e8c5aa51"]]);
createApp(App).mount("#app");
