var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
import { v as vModelText, w as withModifiers, _ as _export_sfc, c as createApp } from "./_plugin-vue_export-helper-7fiB1ynU.js";
import { d as defineComponent, r as ref, c as computed, o as onMounted, C as getPlanFullListAPI, s as logError, a as createElementBlock, b as openBlock, f as createBaseVNode, e as createCommentVNode, t as toDisplayString, q as createStaticVNode, F as Fragment, p as renderList, n as normalizeClass, i as createTextVNode, j as withDirectives, D as nextTick, E as updateCustomerPriceAPI, G as updateCustomerQuotaAPI } from "./client-F2KO4iwg.js";
const _hoisted_1 = { class: "app-container" };
const _hoisted_2 = { class: "fulllist-container" };
const _hoisted_3 = { class: "toolbar-container" };
const _hoisted_4 = { class: "toolbar-left" };
const _hoisted_5 = { class: "date-display" };
const _hoisted_6 = { class: "date-value" };
const _hoisted_7 = { class: "toolbar-right" };
const _hoisted_8 = { class: "item-count" };
const _hoisted_9 = { class: "display-content" };
const _hoisted_10 = {
  key: 0,
  class: "loading-state"
};
const _hoisted_11 = {
  key: 1,
  class: "error-state"
};
const _hoisted_12 = { class: "error-text" };
const _hoisted_13 = {
  key: 2,
  class: "table-container"
};
const _hoisted_14 = { class: "table-cell product-info-cell" };
const _hoisted_15 = { class: "product-image-container" };
const _hoisted_16 = ["src", "alt"];
const _hoisted_17 = {
  key: 0,
  class: "check-icon",
  viewBox: "0 0 24 24",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_18 = {
  key: 1,
  class: "pending-icon",
  viewBox: "0 0 24 24",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_19 = { class: "product-details" };
const _hoisted_20 = ["title"];
const _hoisted_21 = { class: "product-ids" };
const _hoisted_22 = { class: "product-id" };
const _hoisted_23 = { class: "plan-id" };
const _hoisted_24 = { class: "table-cell quota-cell" };
const _hoisted_25 = { class: "quota-info" };
const _hoisted_26 = { class: "quota-item" };
const _hoisted_27 = { class: "quota-item" };
const _hoisted_28 = { class: "quota-header" };
const _hoisted_29 = ["onClick"];
const _hoisted_30 = {
  key: 1,
  class: "quota-value-container"
};
const _hoisted_31 = { class: "quota-suggested-line" };
const _hoisted_32 = { class: "strikethrough orange-strikethrough" };
const _hoisted_33 = { class: "quota-modified-line" };
const _hoisted_34 = { class: "modified orange-modified" };
const _hoisted_35 = { class: "table-cell price-cell" };
const _hoisted_36 = { class: "price-info" };
const _hoisted_37 = { class: "price-item" };
const _hoisted_38 = { class: "price-item" };
const _hoisted_39 = { class: "price-header" };
const _hoisted_40 = ["onClick"];
const _hoisted_41 = {
  key: 1,
  class: "price-value-container"
};
const _hoisted_42 = { class: "price-suggested-line" };
const _hoisted_43 = { class: "strikethrough orange-strikethrough" };
const _hoisted_44 = { class: "price-modified-line" };
const _hoisted_45 = { class: "modified orange-modified" };
const _hoisted_46 = { class: "table-cell sales-cell" };
const _hoisted_47 = { class: "sales-info" };
const _hoisted_48 = { class: "sales-item" };
const _hoisted_49 = { class: "sales-value" };
const _hoisted_50 = { class: "sales-item" };
const _hoisted_51 = { class: "sales-value" };
const _hoisted_52 = { class: "sales-item" };
const _hoisted_53 = { class: "sales-value" };
const _hoisted_54 = { class: "table-cell promotion-cell" };
const _hoisted_55 = { class: "promotion-info" };
const _hoisted_56 = { class: "promotion-item" };
const _hoisted_57 = { class: "promotion-value" };
const _hoisted_58 = { class: "promotion-item" };
const _hoisted_59 = { class: "promotion-value" };
const _hoisted_60 = { class: "promotion-item" };
const _hoisted_61 = { class: "promotion-value warning" };
const _hoisted_62 = { class: "promotion-item" };
const _hoisted_63 = { class: "promotion-value" };
const _hoisted_64 = { class: "promotion-item" };
const _hoisted_65 = { class: "promotion-value" };
const _hoisted_66 = { class: "promotion-item" };
const _hoisted_67 = { class: "promotion-value" };
const _hoisted_68 = { class: "promotion-item" };
const _hoisted_69 = { class: "promotion-value" };
const _hoisted_70 = { class: "promotion-item" };
const _hoisted_71 = { class: "promotion-value" };
const _hoisted_72 = { class: "edit-modal-body" };
const _hoisted_73 = { class: "edit-modal-info" };
const _hoisted_74 = { class: "product-info-item" };
const _hoisted_75 = { class: "info-value" };
const _hoisted_76 = { class: "product-info-item" };
const _hoisted_77 = { class: "info-value" };
const _hoisted_78 = { class: "product-info-item" };
const _hoisted_79 = { class: "info-value current-price" };
const _hoisted_80 = { class: "edit-modal-input-group" };
const _hoisted_81 = { class: "edit-modal-input-wrapper" };
const _hoisted_82 = {
  key: 0,
  class: "edit-modal-error"
};
const _hoisted_83 = { class: "edit-modal-body" };
const _hoisted_84 = { class: "edit-modal-info" };
const _hoisted_85 = { class: "product-info-item" };
const _hoisted_86 = { class: "info-value" };
const _hoisted_87 = { class: "product-info-item" };
const _hoisted_88 = { class: "info-value" };
const _hoisted_89 = { class: "product-info-item" };
const _hoisted_90 = { class: "info-value current-price" };
const _hoisted_91 = { class: "edit-modal-input-group" };
const _hoisted_92 = { class: "edit-modal-input-wrapper" };
const _hoisted_93 = {
  key: 0,
  class: "edit-modal-error"
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "App",
  setup(__props) {
    const planFullListData = ref([]);
    const isLoading = ref(false);
    const isInitialLoading = ref(true);
    const loadError = ref("");
    const selectedDateRange = ref({
      beginDate: "",
      endDate: ""
    });
    const totalItems = computed(() => planFullListData.value.length);
    const displayDate = computed(() => {
      if (selectedDateRange.value.beginDate) {
        const date = new Date(selectedDateRange.value.beginDate);
        return date.toLocaleDateString("zh-CN", { year: "numeric", month: "2-digit", day: "2-digit" });
      }
      return "昨日";
    });
    const getUserToken = () => __async(this, null, function* () {
      try {
        const result = yield chrome.storage.local.get(["ecommerce_extension_token"]);
        return result.ecommerce_extension_token || null;
      } catch (error) {
        console.error("获取用户token失败:", error);
        return null;
      }
    });
    onMounted(() => __async(this, null, function* () {
      console.log("🔍 FullList App: 组件已挂载");
      const today = /* @__PURE__ */ new Date();
      const yesterday = /* @__PURE__ */ new Date();
      yesterday.setDate(today.getDate() - 1);
      const yesterdayStr = yesterday.toISOString().split("T")[0] || "";
      selectedDateRange.value = {
        beginDate: yesterdayStr,
        endDate: yesterdayStr
      };
      console.log("🔍 FullList App: 昨日日期设置完成", {
        beginDate: selectedDateRange.value.beginDate,
        endDate: selectedDateRange.value.endDate
      });
      yield loadPlanFullListData();
    }));
    const loadPlanFullListData = () => __async(this, null, function* () {
      const token = yield getUserToken();
      if (!token) {
        console.log("用户token不存在，跳过加载完整计划列表数据");
        loadError.value = "用户未登录，请先登录";
        return;
      }
      if (!selectedDateRange.value.beginDate || !selectedDateRange.value.endDate) {
        console.log("日期范围未选择，跳过加载完整计划列表数据");
        loadError.value = "请选择日期范围";
        return;
      }
      try {
        isLoading.value = true;
        loadError.value = "";
        console.log("开始加载完整计划列表数据...", {
          dateRange: selectedDateRange.value,
          token: token.substring(0, 10) + "..."
        });
        const response = yield getPlanFullListAPI(token, selectedDateRange.value);
        if (response.code === "0" && response.data) {
          planFullListData.value = response.data;
          console.log("✅ 完整计划列表数据加载成功:", {
            total: response.total || response.data.length,
            itemsCount: planFullListData.value.length,
            dateRange: selectedDateRange.value
          });
        } else {
          throw new Error(response.msg || "获取完整计划列表失败");
        }
      } catch (error) {
        console.error("加载完整计划列表数据失败:", error);
        loadError.value = error.message || "加载数据失败";
        logError(error, "加载完整计划列表数据", {
          additionalInfo: `用户token: ${token.substring(0, 10)}..., 日期区间: ${selectedDateRange.value.beginDate} - ${selectedDateRange.value.endDate}`
        });
      } finally {
        isLoading.value = false;
        isInitialLoading.value = false;
      }
    });
    const refreshData = () => __async(this, null, function* () {
      console.log("🔍 FullList App: 手动刷新数据");
      yield loadPlanFullListData();
    });
    const formatPrice = (price) => {
      if (price === null || price === void 0) return "-";
      return `${price.toFixed(2)}`;
    };
    const formatNumber = (num) => {
      if (num === null || num === void 0) return "-";
      return num.toLocaleString();
    };
    const formatActualQuotaDisplay = (realQuota, baseQuota) => {
      const actualQuota = realQuota || baseQuota;
      if (actualQuota === null || actualQuota === void 0) {
        return { suggestValue: "-", class: "" };
      }
      const actualValue = actualQuota.toFixed(2);
      if (baseQuota !== null && baseQuota !== void 0) {
        if (actualQuota > baseQuota) {
          return { suggestValue: actualValue, class: "quota-increase" };
        } else if (actualQuota < baseQuota) {
          return { suggestValue: actualValue, class: "quota-decrease" };
        } else {
          return { suggestValue: actualValue, class: "quota-same" };
        }
      }
      return { suggestValue: actualValue, class: "" };
    };
    const formatQuotaDisplay = (calcQuota, customerQuota) => {
      const suggestValue = calcQuota === null ? "-" : calcQuota.toFixed(2);
      const modifyValue = customerQuota === null ? "-" : customerQuota.toFixed(2);
      const showSuggestOnly = customerQuota === null;
      let quotaClass = "quota-suggested";
      return { suggestValue, modifyValue, showSuggestOnly, class: quotaClass };
    };
    const formatActualPriceDisplay = (realPrice, basePrice) => {
      const actualPrice = realPrice || basePrice;
      if (actualPrice === null || actualPrice === void 0) {
        return { suggestValue: "-", class: "" };
      }
      const actualValue = `${actualPrice.toFixed(2)}`;
      if (basePrice !== null && basePrice !== void 0) {
        if (actualPrice > basePrice) {
          return { suggestValue: actualValue, class: "price-increase" };
        } else if (actualPrice < basePrice) {
          return { suggestValue: actualValue, class: "price-decrease" };
        } else {
          return { suggestValue: actualValue, class: "price-same" };
        }
      }
      return { suggestValue: actualValue, class: "" };
    };
    const formatPriceDisplay = (calcPrice, customerPrice) => {
      const suggestValue = calcPrice === null ? "-" : `${calcPrice.toFixed(2)}`;
      const modifyValue = customerPrice === null ? "-" : `${customerPrice.toFixed(2)}`;
      const showSuggestOnly = customerPrice === null;
      let priceClass = "price-suggested";
      return { suggestValue, modifyValue, showSuggestOnly, class: priceClass };
    };
    const handleImageError = (event) => {
      const target = event.target;
      target.src = "data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTIwIiBoZWlnaHQ9IjE1MCIgdmlld0JveD0iMCAwIDEyMCAxNTAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIxMjAiIGhlaWdodD0iMTUwIiBmaWxsPSIjRjNGNEY2Ii8+CjxwYXRoIGQ9Ik00MCA2MEg4MFY5MEg0MFY2MFoiIGZpbGw9IiNEMUQ1REIiLz4KPHN2Zz4K";
    };
    const showEditModal = ref(false);
    const editingItem = ref(null);
    const editPriceValue = ref("");
    const editPriceError = ref("");
    const showEditQuotaModal = ref(false);
    const editingQuotaItem = ref(null);
    const editQuotaValue = ref("");
    const editQuotaError = ref("");
    const editPrice = (item) => __async(this, null, function* () {
      const currentPrice = item.customerPrice || item.calcPrice || 0;
      editingItem.value = item;
      editPriceValue.value = currentPrice.toFixed(2);
      editPriceError.value = "";
      showEditModal.value = true;
      yield nextTick();
      const input = document.querySelector(".edit-modal-input");
      if (input) {
        input.focus();
        input.select();
      }
    });
    const confirmEditPrice = () => __async(this, null, function* () {
      var _a, _b;
      if (!editingItem.value) return;
      const priceString = String(editPriceValue.value || "").trim();
      const priceValue = parseFloat(priceString);
      if (isNaN(priceValue) || priceValue < 0) {
        editPriceError.value = "请输入有效的价格数值";
        return;
      }
      try {
        const token = yield getUserToken();
        if (!token) {
          editPriceError.value = "用户未登录，请重新登录";
          return;
        }
        const updateData = {
          id: editingItem.value.id,
          customerValue: priceValue
        };
        console.log("🔄 开始更新客户价格:", updateData);
        const response = yield updateCustomerPriceAPI(token, updateData);
        if (response.code === "0") {
          editingItem.value.customerPrice = priceValue;
          console.log("✅ 价格修改成功:", {
            goodsId: editingItem.value.goodsId,
            planId: editingItem.value.planId,
            oldPrice: editingItem.value.customerPrice || editingItem.value.calcPrice || 0,
            newPrice: priceValue,
            response
          });
          showEditModal.value = false;
          editingItem.value = null;
          editPriceValue.value = "";
          editPriceError.value = "";
        } else {
          editPriceError.value = response.msg || "更新价格失败";
          console.error("❌ 价格更新失败:", response);
        }
      } catch (error) {
        console.error("❌ 价格更新异常:", error);
        editPriceError.value = error.message || "更新价格时发生错误";
        logError(error, "更新客户价格", {
          additionalInfo: `商品ID: ${(_a = editingItem.value) == null ? void 0 : _a.goodsId}, 计划ID: ${(_b = editingItem.value) == null ? void 0 : _b.planId}, 新价格: ${priceValue}`
        });
      }
    });
    const cancelEditPrice = () => {
      showEditModal.value = false;
      editingItem.value = null;
      editPriceValue.value = "";
      editPriceError.value = "";
    };
    const handleKeydown = (event) => {
      if (event.key === "Enter") {
        confirmEditPrice();
      } else if (event.key === "Escape") {
        cancelEditPrice();
      }
    };
    const editQuota = (item) => __async(this, null, function* () {
      const currentQuota = item.customerQuota || item.calcQuota || 0;
      editingQuotaItem.value = item;
      editQuotaValue.value = currentQuota.toFixed(2);
      editQuotaError.value = "";
      showEditQuotaModal.value = true;
      yield nextTick();
      const input = document.querySelector(".edit-quota-modal-input");
      if (input) {
        input.focus();
        input.select();
      }
    });
    const confirmEditQuota = () => __async(this, null, function* () {
      var _a, _b;
      if (!editingQuotaItem.value) return;
      const quotaString = String(editQuotaValue.value || "").trim();
      const quotaValue = parseFloat(quotaString);
      if (isNaN(quotaValue) || quotaValue < 0) {
        editQuotaError.value = "请输入有效的限额数值";
        return;
      }
      try {
        const token = yield getUserToken();
        if (!token) {
          editQuotaError.value = "用户未登录，请重新登录";
          return;
        }
        const updateData = {
          id: editingQuotaItem.value.id,
          customerValue: quotaValue
        };
        console.log("🔄 开始更新客户限额:", updateData);
        const response = yield updateCustomerQuotaAPI(token, updateData);
        if (response.code === "0") {
          editingQuotaItem.value.customerQuota = quotaValue;
          console.log("✅ 限额修改成功:", {
            goodsId: editingQuotaItem.value.goodsId,
            planId: editingQuotaItem.value.planId,
            oldQuota: editingQuotaItem.value.customerQuota || editingQuotaItem.value.calcQuota || 0,
            newQuota: quotaValue,
            response
          });
          showEditQuotaModal.value = false;
          editingQuotaItem.value = null;
          editQuotaValue.value = "";
          editQuotaError.value = "";
        } else {
          editQuotaError.value = response.msg || "更新限额失败";
          console.error("❌ 限额更新失败:", response);
        }
      } catch (error) {
        console.error("❌ 限额更新异常:", error);
        editQuotaError.value = error.message || "更新限额时发生错误";
        logError(error, "更新客户限额", {
          additionalInfo: `商品ID: ${(_a = editingQuotaItem.value) == null ? void 0 : _a.goodsId}, 计划ID: ${(_b = editingQuotaItem.value) == null ? void 0 : _b.planId}, 新限额: ${quotaValue}`
        });
      }
    });
    const cancelEditQuota = () => {
      showEditQuotaModal.value = false;
      editingQuotaItem.value = null;
      editQuotaValue.value = "";
      editQuotaError.value = "";
    };
    const handleQuotaKeydown = (event) => {
      if (event.key === "Enter") {
        confirmEditQuota();
      } else if (event.key === "Escape") {
        cancelEditQuota();
      }
    };
    return (_ctx, _cache) => {
      var _a, _b, _c, _d, _e, _f, _g, _h;
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createBaseVNode("div", _hoisted_2, [
          createBaseVNode("div", _hoisted_3, [
            createBaseVNode("div", _hoisted_4, [
              createBaseVNode("div", _hoisted_5, [
                _cache[4] || (_cache[4] = createBaseVNode("span", { class: "date-label" }, "📅 数据日期：", -1)),
                createBaseVNode("span", _hoisted_6, toDisplayString(displayDate.value), 1)
              ])
            ]),
            createBaseVNode("div", _hoisted_7, [
              createBaseVNode("button", {
                onClick: refreshData,
                class: "refresh-icon-btn",
                title: "刷新数据"
              }, [..._cache[5] || (_cache[5] = [
                createBaseVNode("svg", {
                  width: "18",
                  height: "18",
                  viewBox: "0 0 24 24",
                  fill: "none",
                  xmlns: "http://www.w3.org/2000/svg"
                }, [
                  createBaseVNode("path", {
                    d: "M1 4v6h6",
                    stroke: "currentColor",
                    "stroke-width": "2",
                    "stroke-linecap": "round",
                    "stroke-linejoin": "round"
                  }),
                  createBaseVNode("path", {
                    d: "M23 20v-6h-6",
                    stroke: "currentColor",
                    "stroke-width": "2",
                    "stroke-linecap": "round",
                    "stroke-linejoin": "round"
                  }),
                  createBaseVNode("path", {
                    d: "M20.49 9A9 9 0 0 0 5.64 5.64L1 10m22 4l-4.64 4.36A9 9 0 0 1 3.51 15",
                    stroke: "currentColor",
                    "stroke-width": "2",
                    "stroke-linecap": "round",
                    "stroke-linejoin": "round"
                  })
                ], -1)
              ])]),
              createBaseVNode("span", _hoisted_8, "共 " + toDisplayString(totalItems.value) + " 件商品", 1)
            ])
          ]),
          createBaseVNode("div", _hoisted_9, [
            isLoading.value || isInitialLoading.value ? (openBlock(), createElementBlock("div", _hoisted_10, [..._cache[6] || (_cache[6] = [
              createBaseVNode("div", { class: "loading-spinner" }, null, -1),
              createBaseVNode("div", { class: "loading-text" }, "正在加载完整计划列表...", -1)
            ])])) : loadError.value ? (openBlock(), createElementBlock("div", _hoisted_11, [
              _cache[7] || (_cache[7] = createBaseVNode("div", { class: "error-icon" }, "⚠️", -1)),
              createBaseVNode("div", _hoisted_12, toDisplayString(loadError.value), 1),
              createBaseVNode("div", { class: "error-actions" }, [
                createBaseVNode("button", {
                  class: "retry-button",
                  onClick: loadPlanFullListData
                }, "重试")
              ])
            ])) : !isLoading.value && !loadError.value && !isInitialLoading.value ? (openBlock(), createElementBlock("div", _hoisted_13, [
              _cache[27] || (_cache[27] = createStaticVNode('<div class="table-header-row" data-v-0dfbddc8><div class="table-header-cell product-info-header" data-v-0dfbddc8>商品信息</div><div class="table-header-cell quota-header" data-v-0dfbddc8>限额信息</div><div class="table-header-cell price-header" data-v-0dfbddc8>出价信息</div><div class="table-header-cell sales-header" data-v-0dfbddc8>销售数据</div><div class="table-header-cell promotion-header" data-v-0dfbddc8>推广数据</div></div>', 1)),
              (openBlock(true), createElementBlock(Fragment, null, renderList(planFullListData.value, (item, index) => {
                return openBlock(), createElementBlock("div", {
                  key: item.id,
                  class: normalizeClass(["table-row", { "row-even": index % 2 === 0 }])
                }, [
                  createBaseVNode("div", _hoisted_14, [
                    createBaseVNode("div", _hoisted_15, [
                      createBaseVNode("img", {
                        src: item.goodsImgUrl,
                        alt: item.goodsName,
                        class: "product-image",
                        onError: handleImageError
                      }, null, 40, _hoisted_16),
                      createBaseVNode("div", {
                        class: normalizeClass(["sync-status-icon", { "sync-success": item.isEffect === "1", "sync-pending": item.isEffect === "0" }])
                      }, [
                        item.isEffect === "1" ? (openBlock(), createElementBlock("svg", _hoisted_17, [..._cache[8] || (_cache[8] = [
                          createBaseVNode("circle", {
                            cx: "12",
                            cy: "12",
                            r: "10",
                            fill: "#10B981"
                          }, null, -1),
                          createBaseVNode("path", {
                            d: "M9 12l2 2 4-4",
                            stroke: "white",
                            "stroke-width": "2",
                            "stroke-linecap": "round",
                            "stroke-linejoin": "round"
                          }, null, -1)
                        ])])) : (openBlock(), createElementBlock("svg", _hoisted_18, [..._cache[9] || (_cache[9] = [
                          createBaseVNode("circle", {
                            cx: "12",
                            cy: "12",
                            r: "10",
                            fill: "#F59E0B"
                          }, null, -1),
                          createBaseVNode("path", {
                            d: "M12 6v6l4 2",
                            stroke: "white",
                            "stroke-width": "2",
                            "stroke-linecap": "round",
                            "stroke-linejoin": "round"
                          }, null, -1)
                        ])]))
                      ], 2)
                    ]),
                    createBaseVNode("div", _hoisted_19, [
                      createBaseVNode("h3", {
                        class: "product-name",
                        title: item.goodsName
                      }, toDisplayString(item.goodsName), 9, _hoisted_20),
                      createBaseVNode("div", _hoisted_21, [
                        createBaseVNode("span", _hoisted_22, "商品ID: " + toDisplayString(item.goodsId), 1),
                        createBaseVNode("span", _hoisted_23, "计划ID: " + toDisplayString(item.planId), 1)
                      ])
                    ])
                  ]),
                  createBaseVNode("div", _hoisted_24, [
                    createBaseVNode("div", _hoisted_25, [
                      createBaseVNode("div", _hoisted_26, [
                        _cache[10] || (_cache[10] = createBaseVNode("span", { class: "quota-label" }, "实际限额", -1)),
                        createBaseVNode("span", {
                          class: normalizeClass(["quota-value actual", formatActualQuotaDisplay(item.realQuota, item.baseQuota).class])
                        }, toDisplayString(formatActualQuotaDisplay(item.realQuota, item.baseQuota).suggestValue), 3)
                      ]),
                      createBaseVNode("div", _hoisted_27, [
                        createBaseVNode("div", _hoisted_28, [
                          _cache[12] || (_cache[12] = createBaseVNode("span", { class: "quota-label" }, "建议限额", -1)),
                          createBaseVNode("button", {
                            onClick: ($event) => editQuota(item),
                            class: "edit-quota-btn",
                            title: "编辑建议限额"
                          }, [..._cache[11] || (_cache[11] = [
                            createBaseVNode("svg", {
                              width: "12",
                              height: "12",
                              viewBox: "0 0 24 24",
                              fill: "none",
                              xmlns: "http://www.w3.org/2000/svg"
                            }, [
                              createBaseVNode("path", {
                                d: "M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7",
                                stroke: "currentColor",
                                "stroke-width": "2",
                                "stroke-linecap": "round",
                                "stroke-linejoin": "round"
                              }),
                              createBaseVNode("path", {
                                d: "m18.5 2.5 3 3L12 15l-4 1 1-4 9.5-9.5z",
                                stroke: "currentColor",
                                "stroke-width": "2",
                                "stroke-linecap": "round",
                                "stroke-linejoin": "round"
                              })
                            ], -1)
                          ])], 8, _hoisted_29)
                        ]),
                        createBaseVNode("span", {
                          class: normalizeClass(["quota-value", formatQuotaDisplay(item.calcQuota, item.customerQuota).class])
                        }, [
                          formatQuotaDisplay(item.calcQuota, item.customerQuota).showSuggestOnly ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                            createTextVNode(toDisplayString(formatQuotaDisplay(item.calcQuota, item.customerQuota).suggestValue), 1)
                          ], 64)) : (openBlock(), createElementBlock("div", _hoisted_30, [
                            createBaseVNode("div", _hoisted_31, [
                              createBaseVNode("span", _hoisted_32, toDisplayString(formatQuotaDisplay(item.calcQuota, item.customerQuota).suggestValue), 1)
                            ]),
                            createBaseVNode("div", _hoisted_33, [
                              createBaseVNode("span", _hoisted_34, toDisplayString(formatQuotaDisplay(item.calcQuota, item.customerQuota).modifyValue), 1)
                            ])
                          ]))
                        ], 2)
                      ])
                    ])
                  ]),
                  createBaseVNode("div", _hoisted_35, [
                    createBaseVNode("div", _hoisted_36, [
                      createBaseVNode("div", _hoisted_37, [
                        _cache[13] || (_cache[13] = createBaseVNode("span", { class: "price-label" }, "实际出价", -1)),
                        createBaseVNode("span", {
                          class: normalizeClass(["price-value actual", formatActualPriceDisplay(item.realPrice, item.basePrice).class])
                        }, toDisplayString(formatActualPriceDisplay(item.realPrice, item.basePrice).suggestValue), 3)
                      ]),
                      createBaseVNode("div", _hoisted_38, [
                        createBaseVNode("div", _hoisted_39, [
                          _cache[15] || (_cache[15] = createBaseVNode("span", { class: "price-label" }, "建议出价", -1)),
                          createBaseVNode("button", {
                            onClick: ($event) => editPrice(item),
                            class: "edit-price-btn",
                            title: "编辑建议出价"
                          }, [..._cache[14] || (_cache[14] = [
                            createBaseVNode("svg", {
                              width: "12",
                              height: "12",
                              viewBox: "0 0 24 24",
                              fill: "none",
                              xmlns: "http://www.w3.org/2000/svg"
                            }, [
                              createBaseVNode("path", {
                                d: "M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7",
                                stroke: "currentColor",
                                "stroke-width": "2",
                                "stroke-linecap": "round",
                                "stroke-linejoin": "round"
                              }),
                              createBaseVNode("path", {
                                d: "m18.5 2.5 3 3L12 15l-4 1 1-4 9.5-9.5z",
                                stroke: "currentColor",
                                "stroke-width": "2",
                                "stroke-linecap": "round",
                                "stroke-linejoin": "round"
                              })
                            ], -1)
                          ])], 8, _hoisted_40)
                        ]),
                        createBaseVNode("span", {
                          class: normalizeClass(["price-value", formatPriceDisplay(item.calcPrice, item.customerPrice).class])
                        }, [
                          formatPriceDisplay(item.calcPrice, item.customerPrice).showSuggestOnly ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                            createTextVNode(toDisplayString(formatPriceDisplay(item.calcPrice, item.customerPrice).suggestValue), 1)
                          ], 64)) : (openBlock(), createElementBlock("div", _hoisted_41, [
                            createBaseVNode("div", _hoisted_42, [
                              createBaseVNode("span", _hoisted_43, toDisplayString(formatPriceDisplay(item.calcPrice, item.customerPrice).suggestValue), 1)
                            ]),
                            createBaseVNode("div", _hoisted_44, [
                              createBaseVNode("span", _hoisted_45, toDisplayString(formatPriceDisplay(item.calcPrice, item.customerPrice).modifyValue), 1)
                            ])
                          ]))
                        ], 2)
                      ])
                    ])
                  ]),
                  createBaseVNode("div", _hoisted_46, [
                    createBaseVNode("div", _hoisted_47, [
                      createBaseVNode("div", _hoisted_48, [
                        _cache[16] || (_cache[16] = createBaseVNode("span", { class: "sales-label" }, "支付金额", -1)),
                        createBaseVNode("span", _hoisted_49, toDisplayString(formatPrice(item.paymentAmount)), 1)
                      ]),
                      createBaseVNode("div", _hoisted_50, [
                        _cache[17] || (_cache[17] = createBaseVNode("span", { class: "sales-label" }, "支付件数", -1)),
                        createBaseVNode("span", _hoisted_51, toDisplayString(formatNumber(item.paymentQuantity)), 1)
                      ]),
                      createBaseVNode("div", _hoisted_52, [
                        _cache[18] || (_cache[18] = createBaseVNode("span", { class: "sales-label" }, "访客数", -1)),
                        createBaseVNode("span", _hoisted_53, toDisplayString(formatNumber(item.visitorCount)), 1)
                      ])
                    ])
                  ]),
                  createBaseVNode("div", _hoisted_54, [
                    createBaseVNode("div", _hoisted_55, [
                      createBaseVNode("div", _hoisted_56, [
                        _cache[19] || (_cache[19] = createBaseVNode("span", { class: "promotion-label" }, "展现量", -1)),
                        createBaseVNode("span", _hoisted_57, toDisplayString(formatNumber(item.promImpressions)), 1)
                      ]),
                      createBaseVNode("div", _hoisted_58, [
                        _cache[20] || (_cache[20] = createBaseVNode("span", { class: "promotion-label" }, "点击量", -1)),
                        createBaseVNode("span", _hoisted_59, toDisplayString(formatNumber(item.promClicks)), 1)
                      ]),
                      createBaseVNode("div", _hoisted_60, [
                        _cache[21] || (_cache[21] = createBaseVNode("span", { class: "promotion-label" }, "花费", -1)),
                        createBaseVNode("span", _hoisted_61, toDisplayString(formatPrice(item.promCost)), 1)
                      ]),
                      createBaseVNode("div", _hoisted_62, [
                        _cache[22] || (_cache[22] = createBaseVNode("span", { class: "promotion-label" }, "成交金额", -1)),
                        createBaseVNode("span", _hoisted_63, toDisplayString(formatPrice(item.promPaymentAmount)), 1)
                      ]),
                      createBaseVNode("div", _hoisted_64, [
                        _cache[23] || (_cache[23] = createBaseVNode("span", { class: "promotion-label" }, "加购数量", -1)),
                        createBaseVNode("span", _hoisted_65, toDisplayString(formatNumber(item.promCarTotal)), 1)
                      ]),
                      createBaseVNode("div", _hoisted_66, [
                        _cache[24] || (_cache[24] = createBaseVNode("span", { class: "promotion-label" }, "成交人数", -1)),
                        createBaseVNode("span", _hoisted_67, toDisplayString(formatNumber(item.promBuyers)), 1)
                      ]),
                      createBaseVNode("div", _hoisted_68, [
                        _cache[25] || (_cache[25] = createBaseVNode("span", { class: "promotion-label" }, "PPC", -1)),
                        createBaseVNode("span", _hoisted_69, toDisplayString(formatNumber(item.ppc)), 1)
                      ]),
                      createBaseVNode("div", _hoisted_70, [
                        _cache[26] || (_cache[26] = createBaseVNode("span", { class: "promotion-label" }, "ROI", -1)),
                        createBaseVNode("span", _hoisted_71, toDisplayString(formatNumber(item.roi)), 1)
                      ])
                    ])
                  ])
                ], 2);
              }), 128))
            ])) : createCommentVNode("", true)
          ])
        ]),
        showEditModal.value ? (openBlock(), createElementBlock("div", {
          key: 0,
          class: "edit-modal-overlay",
          onClick: cancelEditPrice
        }, [
          createBaseVNode("div", {
            class: "edit-modal",
            onClick: _cache[1] || (_cache[1] = withModifiers(() => {
            }, ["stop"]))
          }, [
            createBaseVNode("div", { class: "edit-modal-header" }, [
              _cache[29] || (_cache[29] = createBaseVNode("h3", { class: "edit-modal-title" }, "编辑建议出价", -1)),
              createBaseVNode("button", {
                onClick: cancelEditPrice,
                class: "edit-modal-close"
              }, [..._cache[28] || (_cache[28] = [
                createBaseVNode("svg", {
                  width: "16",
                  height: "16",
                  viewBox: "0 0 24 24",
                  fill: "none",
                  xmlns: "http://www.w3.org/2000/svg"
                }, [
                  createBaseVNode("path", {
                    d: "M18 6L6 18M6 6l12 12",
                    stroke: "currentColor",
                    "stroke-width": "2",
                    "stroke-linecap": "round",
                    "stroke-linejoin": "round"
                  })
                ], -1)
              ])])
            ]),
            createBaseVNode("div", _hoisted_72, [
              createBaseVNode("div", _hoisted_73, [
                createBaseVNode("div", _hoisted_74, [
                  _cache[30] || (_cache[30] = createBaseVNode("span", { class: "info-label" }, "商品ID:", -1)),
                  createBaseVNode("span", _hoisted_75, toDisplayString((_a = editingItem.value) == null ? void 0 : _a.goodsId), 1)
                ]),
                createBaseVNode("div", _hoisted_76, [
                  _cache[31] || (_cache[31] = createBaseVNode("span", { class: "info-label" }, "计划ID:", -1)),
                  createBaseVNode("span", _hoisted_77, toDisplayString((_b = editingItem.value) == null ? void 0 : _b.planId), 1)
                ]),
                createBaseVNode("div", _hoisted_78, [
                  _cache[32] || (_cache[32] = createBaseVNode("span", { class: "info-label" }, "当前价格:", -1)),
                  createBaseVNode("span", _hoisted_79, toDisplayString((((_c = editingItem.value) == null ? void 0 : _c.customerPrice) || ((_d = editingItem.value) == null ? void 0 : _d.calcPrice) || 0).toFixed(2)), 1)
                ])
              ]),
              createBaseVNode("div", _hoisted_80, [
                _cache[34] || (_cache[34] = createBaseVNode("label", { class: "edit-modal-label" }, "新价格", -1)),
                createBaseVNode("div", _hoisted_81, [
                  withDirectives(createBaseVNode("input", {
                    "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => editPriceValue.value = $event),
                    type: "number",
                    step: "0.01",
                    min: "0",
                    class: "edit-modal-input",
                    placeholder: "请输入新的建议出价",
                    onKeydown: handleKeydown,
                    ref: "priceInput"
                  }, null, 544), [
                    [vModelText, editPriceValue.value]
                  ]),
                  _cache[33] || (_cache[33] = createBaseVNode("span", { class: "edit-modal-unit" }, "元", -1))
                ]),
                editPriceError.value ? (openBlock(), createElementBlock("div", _hoisted_82, toDisplayString(editPriceError.value), 1)) : createCommentVNode("", true)
              ])
            ]),
            createBaseVNode("div", { class: "edit-modal-footer" }, [
              createBaseVNode("button", {
                onClick: cancelEditPrice,
                class: "edit-modal-btn cancel-btn"
              }, "取消"),
              createBaseVNode("button", {
                onClick: confirmEditPrice,
                class: "edit-modal-btn confirm-btn"
              }, "确认")
            ])
          ])
        ])) : createCommentVNode("", true),
        showEditQuotaModal.value ? (openBlock(), createElementBlock("div", {
          key: 1,
          class: "edit-modal-overlay",
          onClick: cancelEditQuota
        }, [
          createBaseVNode("div", {
            class: "edit-modal",
            onClick: _cache[3] || (_cache[3] = withModifiers(() => {
            }, ["stop"]))
          }, [
            createBaseVNode("div", { class: "edit-modal-header" }, [
              _cache[36] || (_cache[36] = createBaseVNode("h3", { class: "edit-modal-title" }, "编辑建议限额", -1)),
              createBaseVNode("button", {
                onClick: cancelEditQuota,
                class: "edit-modal-close"
              }, [..._cache[35] || (_cache[35] = [
                createBaseVNode("svg", {
                  width: "16",
                  height: "16",
                  viewBox: "0 0 24 24",
                  fill: "none",
                  xmlns: "http://www.w3.org/2000/svg"
                }, [
                  createBaseVNode("path", {
                    d: "M18 6L6 18M6 6l12 12",
                    stroke: "currentColor",
                    "stroke-width": "2",
                    "stroke-linecap": "round",
                    "stroke-linejoin": "round"
                  })
                ], -1)
              ])])
            ]),
            createBaseVNode("div", _hoisted_83, [
              createBaseVNode("div", _hoisted_84, [
                createBaseVNode("div", _hoisted_85, [
                  _cache[37] || (_cache[37] = createBaseVNode("span", { class: "info-label" }, "商品ID:", -1)),
                  createBaseVNode("span", _hoisted_86, toDisplayString((_e = editingQuotaItem.value) == null ? void 0 : _e.goodsId), 1)
                ]),
                createBaseVNode("div", _hoisted_87, [
                  _cache[38] || (_cache[38] = createBaseVNode("span", { class: "info-label" }, "计划ID:", -1)),
                  createBaseVNode("span", _hoisted_88, toDisplayString((_f = editingQuotaItem.value) == null ? void 0 : _f.planId), 1)
                ]),
                createBaseVNode("div", _hoisted_89, [
                  _cache[39] || (_cache[39] = createBaseVNode("span", { class: "info-label" }, "当前限额:", -1)),
                  createBaseVNode("span", _hoisted_90, toDisplayString((((_g = editingQuotaItem.value) == null ? void 0 : _g.customerQuota) || ((_h = editingQuotaItem.value) == null ? void 0 : _h.calcQuota) || 0).toFixed(2)), 1)
                ])
              ]),
              createBaseVNode("div", _hoisted_91, [
                _cache[41] || (_cache[41] = createBaseVNode("label", { class: "edit-modal-label" }, "新限额", -1)),
                createBaseVNode("div", _hoisted_92, [
                  withDirectives(createBaseVNode("input", {
                    "onUpdate:modelValue": _cache[2] || (_cache[2] = ($event) => editQuotaValue.value = $event),
                    type: "number",
                    step: "0.01",
                    min: "0",
                    class: "edit-modal-input edit-quota-modal-input",
                    placeholder: "请输入新的建议限额",
                    onKeydown: handleQuotaKeydown,
                    ref: "quotaInput"
                  }, null, 544), [
                    [vModelText, editQuotaValue.value]
                  ]),
                  _cache[40] || (_cache[40] = createBaseVNode("span", { class: "edit-modal-unit" }, "元", -1))
                ]),
                editQuotaError.value ? (openBlock(), createElementBlock("div", _hoisted_93, toDisplayString(editQuotaError.value), 1)) : createCommentVNode("", true)
              ])
            ]),
            createBaseVNode("div", { class: "edit-modal-footer" }, [
              createBaseVNode("button", {
                onClick: cancelEditQuota,
                class: "edit-modal-btn cancel-btn"
              }, "取消"),
              createBaseVNode("button", {
                onClick: confirmEditQuota,
                class: "edit-modal-btn confirm-btn"
              }, "确认")
            ])
          ])
        ])) : createCommentVNode("", true)
      ]);
    };
  }
});
const App = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-0dfbddc8"]]);
const app = createApp(App);
app.mount("#app");
