var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
import { a0 as reactive, r as ref, s as logError, c as computed } from "./client-F2KO4iwg.js";
var TaskStatus = /* @__PURE__ */ ((TaskStatus2) => {
  TaskStatus2[TaskStatus2["PENDING"] = 0] = "PENDING";
  TaskStatus2[TaskStatus2["SYNCING"] = 1] = "SYNCING";
  TaskStatus2[TaskStatus2["COMPLETED"] = 2] = "COMPLETED";
  TaskStatus2[TaskStatus2["FAILED"] = 3] = "FAILED";
  return TaskStatus2;
})(TaskStatus || {});
var StageStatus = /* @__PURE__ */ ((StageStatus2) => {
  StageStatus2[StageStatus2["PENDING_COLLECT"] = 10] = "PENDING_COLLECT";
  StageStatus2[StageStatus2["COLLECTING"] = 11] = "COLLECTING";
  StageStatus2[StageStatus2["COLLECT_ERROR"] = 13] = "COLLECT_ERROR";
  StageStatus2[StageStatus2["COLLECT_COMPLETED"] = 20] = "COLLECT_COMPLETED";
  StageStatus2[StageStatus2["SYNCING_DETAIL"] = 21] = "SYNCING_DETAIL";
  StageStatus2[StageStatus2["SYNC_ERROR"] = 23] = "SYNC_ERROR";
  StageStatus2[StageStatus2["SYNC_COMPLETED"] = 30] = "SYNC_COMPLETED";
  StageStatus2[StageStatus2["ANALYZING"] = 31] = "ANALYZING";
  StageStatus2[StageStatus2["ANALYZE_ERROR"] = 33] = "ANALYZE_ERROR";
  StageStatus2[StageStatus2["ANALYZE_COMPLETED"] = 40] = "ANALYZE_COMPLETED";
  return StageStatus2;
})(StageStatus || {});
function getTaskStatusInfo(taskStatus, stageStatus) {
  if (stageStatus !== void 0) {
    return getStageStatusInfo(stageStatus, taskStatus);
  }
  switch (taskStatus) {
    case 0:
      return {
        taskStatus,
        label: "待同步",
        description: "等待开始同步",
        isCompleted: false,
        isProcessing: false,
        isError: false,
        canClick: canClickSyncStage(taskStatus),
        showFileUpload: false,
        iconType: "pending",
        stageColors: {
          collect: "gray",
          sync: "gray",
          analyze: "gray"
        }
      };
    case 1:
      return {
        taskStatus,
        label: "同步中",
        description: "正在同步数据",
        isCompleted: false,
        isProcessing: true,
        isError: false,
        canClick: false,
        showFileUpload: false,
        iconType: "loading",
        stageColors: {
          collect: "green",
          sync: "green-blinking",
          analyze: "gray"
        }
      };
    case 2:
      return {
        taskStatus,
        label: "已完成",
        description: "同步任务已完成",
        isCompleted: true,
        isProcessing: false,
        isError: false,
        canClick: false,
        showFileUpload: false,
        iconType: "completed",
        stageColors: {
          collect: "green",
          sync: "green",
          analyze: "green"
        }
      };
    case 3:
      return {
        taskStatus,
        label: "同步失败",
        description: "同步任务失败，请重新同步",
        isCompleted: false,
        isProcessing: false,
        isError: true,
        canClick: false,
        showFileUpload: false,
        iconType: "error",
        stageColors: {
          collect: "gray",
          sync: "gray",
          analyze: "gray"
        },
        errorMessage: "同步任务失败，请重新同步"
      };
    default:
      return {
        taskStatus: 0,
        label: "未知状态",
        description: "未知状态",
        isCompleted: false,
        isProcessing: false,
        isError: true,
        canClick: false,
        showFileUpload: false,
        iconType: "error",
        stageColors: {
          collect: "gray",
          sync: "gray",
          analyze: "gray"
        },
        errorMessage: "未知状态，请刷新页面重试"
      };
  }
}
function getStageStatusInfo(stageStatus, taskStatus) {
  switch (stageStatus) {
    case 10:
      return {
        taskStatus,
        stageStatus,
        label: "待收集",
        description: "等待开始收集数据",
        isCompleted: false,
        isProcessing: false,
        isError: false,
        canClick: false,
        showFileUpload: false,
        iconType: "pending",
        stageColors: {
          collect: "gray",
          sync: "gray",
          analyze: "gray"
        }
      };
    case 11:
      return {
        taskStatus,
        stageStatus,
        label: "收集中",
        description: "正在收集数据",
        isCompleted: false,
        isProcessing: true,
        isError: false,
        canClick: false,
        showFileUpload: false,
        iconType: "loading",
        stageColors: {
          collect: "orange",
          sync: "gray",
          analyze: "gray"
        }
      };
    case 13:
      return {
        taskStatus,
        stageStatus,
        label: "收集异常",
        description: "数据收集失败",
        isCompleted: false,
        isProcessing: false,
        isError: true,
        canClick: false,
        showFileUpload: false,
        iconType: "error",
        stageColors: {
          collect: "red",
          sync: "gray",
          analyze: "gray"
        },
        errorMessage: "数据收集过程中发生异常，请检查网络连接或重试"
      };
    case 20:
      return {
        taskStatus,
        stageStatus,
        label: "收集完成",
        description: "数据收集完成，等待同步",
        isCompleted: false,
        isProcessing: true,
        isError: false,
        canClick: true,
        showFileUpload: true,
        iconType: "loading",
        stageColors: {
          collect: "green",
          sync: "orange",
          analyze: "gray"
        }
      };
    case 21:
      return {
        taskStatus,
        stageStatus,
        label: "同步中",
        description: "正在同步数据",
        isCompleted: false,
        isProcessing: true,
        isError: false,
        canClick: false,
        showFileUpload: false,
        iconType: "loading",
        stageColors: {
          collect: "green",
          sync: "orange",
          analyze: "gray"
        }
      };
    case 23:
      return {
        taskStatus,
        stageStatus,
        label: "同步异常",
        description: "数据同步失败",
        isCompleted: false,
        isProcessing: false,
        isError: true,
        canClick: false,
        showFileUpload: false,
        iconType: "error",
        stageColors: {
          collect: "green",
          sync: "red",
          analyze: "gray"
        },
        errorMessage: "数据同步过程中发生异常，请检查网络连接或重试"
      };
    case 30:
      return {
        taskStatus,
        stageStatus,
        label: "同步完成",
        description: "数据同步完成，等待分析",
        isCompleted: false,
        isProcessing: false,
        isError: false,
        canClick: false,
        showFileUpload: false,
        iconType: "loading",
        stageColors: {
          collect: "green",
          sync: "green",
          analyze: "gray"
        }
      };
    case 31:
      return {
        taskStatus,
        stageStatus,
        label: "分析中",
        description: "正在分析数据",
        isCompleted: false,
        isProcessing: true,
        isError: false,
        canClick: false,
        showFileUpload: false,
        iconType: "loading",
        stageColors: {
          collect: "green",
          sync: "green",
          analyze: "orange"
        }
      };
    case 33:
      return {
        taskStatus,
        stageStatus,
        label: "分析异常",
        description: "数据分析失败，需要重新同步",
        isCompleted: false,
        isProcessing: false,
        isError: true,
        canClick: false,
        showFileUpload: false,
        iconType: "error",
        stageColors: {
          collect: "green",
          sync: "orange",
          analyze: "red"
        },
        errorMessage: "数据分析过程中发生异常，需要重新同步数据"
      };
    case 40:
      return {
        taskStatus,
        stageStatus,
        label: "分析完成",
        description: "数据分析完成，等待任务完成",
        isCompleted: true,
        isProcessing: false,
        isError: false,
        canClick: false,
        showFileUpload: false,
        iconType: "completed",
        stageColors: {
          collect: "green",
          sync: "green",
          analyze: "green"
        }
      };
    default:
      return {
        taskStatus,
        stageStatus,
        label: "未知阶段",
        description: "未知阶段状态",
        isCompleted: false,
        isProcessing: false,
        isError: true,
        canClick: false,
        showFileUpload: false,
        iconType: "error",
        stageColors: {
          collect: "gray",
          sync: "gray",
          analyze: "gray"
        },
        errorMessage: "未知阶段状态，请刷新页面重试"
      };
  }
}
function getStageClass(taskStatus, stage, stageStatus) {
  const statusInfo = getTaskStatusInfo(taskStatus, stageStatus);
  let stageKey;
  switch (stage) {
    case "收集":
      stageKey = "collect";
      break;
    case "同步":
      stageKey = "sync";
      break;
    case "分析":
      stageKey = "analyze";
      break;
    default:
      return "pending";
  }
  const color = statusInfo.stageColors[stageKey];
  switch (color) {
    case "gray":
      return "pending";
    case "green":
      return "completed";
    case "green-blinking":
      return "current blinking";
    case "orange":
      return "orange";
    case "red":
      return "error";
    default:
      return "pending";
  }
}
function canClickSyncStage(taskStatus, stageStatus) {
  return taskStatus === 0;
}
const DEFAULT_STATE = {
  sycm: {
    status: TaskStatus.PENDING,
    completed: false,
    progress: "",
    lastUpdate: Date.now()
  },
  wxt: {
    status: TaskStatus.PENDING,
    completed: false,
    progress: "",
    lastUpdate: Date.now()
  },
  isDataSynced: false,
  lastGlobalUpdate: Date.now()
};
const globalState = reactive(__spreadValues({}, DEFAULT_STATE));
const stateListeners = /* @__PURE__ */ new Set();
const stateHistory = ref([]);
class GlobalStateManager {
  // 获取当前状态
  static getState() {
    return globalState;
  }
  // 获取生意参谋状态
  static getSycmState() {
    return globalState.sycm;
  }
  // 获取万相台状态
  static getWxtState() {
    return globalState.wxt;
  }
  // 获取数据同步状态
  static getDataSyncedState() {
    return globalState.isDataSynced;
  }
  // 更新生意参谋状态
  static updateSycmStatus(status, source = "unknown", progress = "") {
    const oldState = __spreadValues({}, globalState.sycm);
    globalState.sycm.status = status;
    globalState.sycm.completed = status === TaskStatus.COMPLETED;
    globalState.sycm.progress = progress;
    globalState.sycm.lastUpdate = Date.now();
    globalState.lastGlobalUpdate = Date.now();
    this.updateDataSyncedState();
    this.emitStateUpdate({
      type: "sycm",
      oldState: { sycm: oldState },
      newState: { sycm: __spreadValues({}, globalState.sycm) },
      source,
      timestamp: Date.now()
    });
    this.saveToStorage();
    console.log(`🔄 [GLOBAL_STATE] 生意参谋状态更新: ${TaskStatus[status]} (来源: ${source})`);
  }
  // 更新万相台状态
  static updateWxtStatus(status, source = "unknown", progress = "") {
    const oldState = __spreadValues({}, globalState.wxt);
    globalState.wxt.status = status;
    globalState.wxt.completed = status === TaskStatus.COMPLETED;
    globalState.wxt.progress = progress;
    globalState.wxt.lastUpdate = Date.now();
    globalState.lastGlobalUpdate = Date.now();
    this.updateDataSyncedState();
    this.emitStateUpdate({
      type: "wxt",
      oldState: { wxt: oldState },
      newState: { wxt: __spreadValues({}, globalState.wxt) },
      source,
      timestamp: Date.now()
    });
    this.saveToStorage();
    console.log(`🔄 [GLOBAL_STATE] 万相台状态更新: ${TaskStatus[status]} (来源: ${source})`);
  }
  // 同时更新两个状态
  static updateBothStatus(sycmStatus, wxtStatus, source = "unknown", sycmProgress = "", wxtProgress = "") {
    const oldSycmState = __spreadValues({}, globalState.sycm);
    const oldWxtState = __spreadValues({}, globalState.wxt);
    globalState.sycm.status = sycmStatus;
    globalState.sycm.completed = sycmStatus === TaskStatus.COMPLETED;
    globalState.sycm.progress = sycmProgress;
    globalState.sycm.lastUpdate = Date.now();
    globalState.wxt.status = wxtStatus;
    globalState.wxt.completed = wxtStatus === TaskStatus.COMPLETED;
    globalState.wxt.progress = wxtProgress;
    globalState.wxt.lastUpdate = Date.now();
    globalState.lastGlobalUpdate = Date.now();
    this.updateDataSyncedState();
    this.emitStateUpdate({
      type: "both",
      oldState: { sycm: oldSycmState, wxt: oldWxtState },
      newState: { sycm: __spreadValues({}, globalState.sycm), wxt: __spreadValues({}, globalState.wxt) },
      source,
      timestamp: Date.now()
    });
    this.saveToStorage();
    console.log(`🔄 [GLOBAL_STATE] 双状态更新: 生意参谋=${TaskStatus[sycmStatus]}, 万相台=${TaskStatus[wxtStatus]} (来源: ${source})`);
  }
  // 重置所有状态为待同步
  static resetAllStatus(source = "unknown") {
    const oldState = __spreadValues({}, globalState);
    globalState.sycm = __spreadValues({}, DEFAULT_STATE.sycm);
    globalState.wxt = __spreadValues({}, DEFAULT_STATE.wxt);
    globalState.isDataSynced = false;
    globalState.lastGlobalUpdate = Date.now();
    this.emitStateUpdate({
      type: "both",
      oldState,
      newState: __spreadValues({}, globalState),
      source,
      timestamp: Date.now()
    });
    this.saveToStorage();
    console.log(`🔄 [GLOBAL_STATE] 重置所有状态 (来源: ${source})`);
  }
  // 更新全局数据同步状态
  static updateDataSyncedState() {
    const newDataSynced = globalState.sycm.completed && globalState.wxt.completed;
    if (globalState.isDataSynced !== newDataSynced) {
      globalState.isDataSynced = newDataSynced;
      console.log(`🔄 [GLOBAL_STATE] 数据同步状态: ${newDataSynced ? "已同步" : "未同步"}`);
    }
  }
  // 添加状态监听器
  static addStateListener(listener) {
    stateListeners.add(listener);
    return () => {
      stateListeners.delete(listener);
    };
  }
  // 移除状态监听器
  static removeStateListener(listener) {
    stateListeners.delete(listener);
  }
  // 触发状态更新事件
  static emitStateUpdate(event) {
    stateHistory.value.push(event);
    if (stateHistory.value.length > 100) {
      stateHistory.value = stateHistory.value.slice(-50);
    }
    stateListeners.forEach((listener) => {
      try {
        listener(event);
      } catch (error) {
        console.error("状态监听器执行失败:", error);
        logError(error, "状态监听器执行", {
          additionalInfo: `监听器: ${listener.name || "anonymous"}`
        });
      }
    });
  }
  // 从Chrome存储加载状态
  static loadFromStorage() {
    return __async(this, null, function* () {
      try {
        const result = yield chrome.storage.local.get([
          "globalSycmStatus",
          "globalSycmCompleted",
          "globalSycmProgress",
          "globalSycmLastUpdate",
          "globalWxtStatus",
          "globalWxtCompleted",
          "globalWxtProgress",
          "globalWxtLastUpdate",
          "globalDataSynced",
          "globalLastUpdate"
        ]);
        if (result.globalSycmStatus !== void 0) {
          globalState.sycm.status = result.globalSycmStatus;
          globalState.sycm.completed = result.globalSycmCompleted || false;
          globalState.sycm.progress = result.globalSycmProgress || "";
          globalState.sycm.lastUpdate = result.globalSycmLastUpdate || Date.now();
        }
        if (result.globalWxtStatus !== void 0) {
          globalState.wxt.status = result.globalWxtStatus;
          globalState.wxt.completed = result.globalWxtCompleted || false;
          globalState.wxt.progress = result.globalWxtProgress || "";
          globalState.wxt.lastUpdate = result.globalWxtLastUpdate || Date.now();
        }
        globalState.isDataSynced = result.globalDataSynced || false;
        globalState.lastGlobalUpdate = result.globalLastUpdate || Date.now();
        console.log("📂 [GLOBAL_STATE] 从存储加载状态成功");
      } catch (error) {
        console.error("📂 [GLOBAL_STATE] 从存储加载状态失败:", error);
        logError(error, "加载全局状态", {
          additionalInfo: "从Chrome存储加载全局状态失败"
        });
      }
    });
  }
  // 保存状态到Chrome存储
  static saveToStorage() {
    return __async(this, null, function* () {
      try {
        yield chrome.storage.local.set({
          globalSycmStatus: globalState.sycm.status,
          globalSycmCompleted: globalState.sycm.completed,
          globalSycmProgress: globalState.sycm.progress,
          globalSycmLastUpdate: globalState.sycm.lastUpdate,
          globalWxtStatus: globalState.wxt.status,
          globalWxtCompleted: globalState.wxt.completed,
          globalWxtProgress: globalState.wxt.progress,
          globalWxtLastUpdate: globalState.wxt.lastUpdate,
          globalDataSynced: globalState.isDataSynced,
          globalLastUpdate: globalState.lastGlobalUpdate
        });
      } catch (error) {
        console.error("💾 [GLOBAL_STATE] 保存状态到存储失败:", error);
        logError(error, "保存全局状态", {
          additionalInfo: "保存全局状态到Chrome存储失败"
        });
      }
    });
  }
  // 获取状态历史
  static getStateHistory() {
    return stateHistory.value;
  }
  // 清除状态历史
  static clearStateHistory() {
    stateHistory.value = [];
  }
  // 获取状态统计信息
  static getStateStats() {
    return {
      totalUpdates: stateHistory.value.length,
      listenersCount: stateListeners.size,
      lastUpdate: globalState.lastGlobalUpdate,
      sycmLastUpdate: globalState.sycm.lastUpdate,
      wxtLastUpdate: globalState.wxt.lastUpdate
    };
  }
}
const useGlobalState = () => {
  return {
    state: globalState,
    sycmStatus: computed(() => globalState.sycm.status),
    wxtStatus: computed(() => globalState.wxt.status),
    sycmCompleted: computed(() => globalState.sycm.completed),
    wxtCompleted: computed(() => globalState.wxt.completed),
    isDataSynced: computed(() => globalState.isDataSynced),
    sycmProgress: computed(() => globalState.sycm.progress),
    wxtProgress: computed(() => globalState.wxt.progress)
  };
};
export {
  GlobalStateManager as G,
  StageStatus as S,
  TaskStatus as T,
  getStageClass as a,
  getTaskStatusInfo as g,
  useGlobalState as u
};
