var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
const TOKEN_KEY = "ecommerce_extension_token";
const USER_INFO_KEY = "ecommerce_extension_user_info";
const CREDENTIALS_KEY = "ecommerce_extension_credentials";
const saveToken = (token, rememberMe = true, username = "user", accountType) => __async(void 0, null, function* () {
  const userInfo = {
    username,
    token,
    loginTime: Date.now(),
    rememberMe,
    accountType
  };
  try {
    yield chrome.storage.local.set({
      [TOKEN_KEY]: token,
      [USER_INFO_KEY]: userInfo
    });
    console.log("Token保存成功:", { username, rememberMe, userInfo });
  } catch (error) {
    console.error("保存token失败:", error);
    throw new Error("保存登录信息失败");
  }
});
const getUserInfo = () => __async(void 0, null, function* () {
  try {
    const result = yield chrome.storage.local.get([USER_INFO_KEY]);
    const userInfo = result[USER_INFO_KEY] || null;
    console.log("获取用户信息:", userInfo);
    return userInfo;
  } catch (error) {
    console.error("获取用户信息失败:", error);
    return null;
  }
});
const checkToken = () => __async(void 0, null, function* () {
  try {
    const userInfo = yield getUserInfo();
    if (!userInfo || !userInfo.token) {
      return false;
    }
    if (userInfo.rememberMe) {
      return true;
    }
    const now = Date.now();
    const loginTime = userInfo.loginTime;
    const twentyFourHours = 24 * 60 * 60 * 1e3;
    if (now - loginTime > twentyFourHours) {
      yield removeToken();
      return false;
    }
    return true;
  } catch (error) {
    console.error("检查token失败:", error);
    return false;
  }
});
const removeToken = () => __async(void 0, null, function* () {
  try {
    yield chrome.storage.local.remove([TOKEN_KEY, USER_INFO_KEY]);
    console.log("Token已清除");
  } catch (error) {
    console.error("删除token失败:", error);
    throw new Error("退出登录失败");
  }
});
const saveCredentials = (username, password, rememberMe) => __async(void 0, null, function* () {
  try {
    if (rememberMe) {
      yield chrome.storage.local.set({
        [CREDENTIALS_KEY]: {
          username,
          password,
          rememberMe,
          saveTime: Date.now()
        }
      });
      console.log("账号密码保存成功");
    }
  } catch (error) {
    console.error("保存账号密码失败:", error);
  }
});
const getCredentials = () => __async(void 0, null, function* () {
  try {
    const result = yield chrome.storage.local.get([CREDENTIALS_KEY]);
    const credentials = result[CREDENTIALS_KEY] || null;
    if (credentials) {
      console.log("获取保存的账号密码:", {
        username: credentials.username,
        rememberMe: credentials.rememberMe
      });
      return {
        username: credentials.username,
        password: credentials.password,
        rememberMe: credentials.rememberMe
      };
    }
    return null;
  } catch (error) {
    console.error("获取账号密码失败:", error);
    return null;
  }
});
const autoLogin = () => __async(void 0, null, function* () {
  try {
    const isLoggedIn = yield checkToken();
    if (isLoggedIn) {
      const userInfo = yield getUserInfo();
      if (userInfo) {
        console.log("自动登录成功:", userInfo.username);
        return userInfo;
      }
    }
    return null;
  } catch (error) {
    console.error("自动登录失败:", error);
    return null;
  }
});
export {
  autoLogin,
  checkToken,
  getCredentials,
  getUserInfo,
  removeToken,
  saveCredentials,
  saveToken
};
